/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.ConnectionListener;
import com.metamatrix.connector.jdbc.ConnectionStrategy;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.JDBCSourceConnection;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.pool.SourceConnection;
import com.metamatrix.data.pool.SourceConnectionFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;

public abstract class JDBCSourceConnectionFactory
implements SourceConnectionFactory {
    protected static final int NO_ISOLATION_LEVEL_SET = Integer.MIN_VALUE;
    private ConnectorEnvironment environment;

    public void initialize(ConnectorEnvironment env) throws ConnectorException {
        this.environment = env;
    }

    protected ConnectorEnvironment getConnectorEnvironment() {
        return this.environment;
    }

    protected Driver createDriver(String driverClassName) throws ConnectorException {
        if (driverClassName == null || driverClassName.trim().length() == 0) {
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSourceConnectionFactory.Missing_JDBC_driver_class_name_1"));
        }
        try {
            return (Driver)Class.forName(driverClassName).newInstance();
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e, JDBCPlugin.Util.getString("JDBCSourceConnectionFactory.Unable_to_load_the_JDBC_driver_class_6", (Object)driverClassName));
        }
    }

    protected void validateURL(Driver driver, String url) throws ConnectorException {
        if (url == null || url.trim().length() == 0) {
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSourceConnectionFactory.Missing_JDBC_database_name_3"));
        }
        boolean acceptsURL = false;
        try {
            acceptsURL = driver.acceptsURL(url);
        }
        catch (SQLException e) {
            throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
        }
        if (!acceptsURL) {
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSourceConnectionFactory.Driver__7", (Object)driver.getClass().getName(), (Object)url));
        }
    }

    protected SourceConnection createJDBCConnection(Driver driver, String url, int transactionIsolationLevel, Properties userProps) throws ConnectorException {
        Connection connection = null;
        try {
            connection = driver.connect(url, userProps);
            if (transactionIsolationLevel != Integer.MIN_VALUE) {
                connection.setTransactionIsolation(transactionIsolationLevel);
            }
        }
        catch (SQLException e) {
            throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
        }
        return new JDBCSourceConnection(connection, this.environment, this.createConnectionStrategy(), this.getConnectionListener());
    }

    protected ConnectionListener getConnectionListener() {
        return null;
    }

    protected ConnectionStrategy createConnectionStrategy() {
        return null;
    }

    protected int interpretTransactionIsolationLevel(String levelStr) throws ConnectorException {
        int isoLevel = Integer.MIN_VALUE;
        if (levelStr == null || levelStr.trim().length() == 0) {
            return isoLevel;
        }
        if ((levelStr = levelStr.toUpperCase()).equals("TRANSACTION_READ_UNCOMMITTED")) {
            isoLevel = 1;
        } else if (levelStr.equals("TRANSACTION_READ_COMMITTED")) {
            isoLevel = 2;
        } else if (levelStr.equals("TRANSACTION_REPEATABLE_READ")) {
            isoLevel = 4;
        } else if (levelStr.equals("TRANSACTION_SERIALIZABLE")) {
            isoLevel = 8;
        } else if (levelStr.equals("TRANSACTION_NONE")) {
            isoLevel = 0;
        } else {
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSourceConnectionFactory.til", (Object)levelStr));
        }
        return isoLevel;
    }

    protected void shutdown() {
    }
}

