/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.JDBCBaseExecution;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.extension.ResultsTranslator;
import com.metamatrix.connector.jdbc.extension.SQLTranslator;
import com.metamatrix.connector.jdbc.extension.TranslatedCommand;
import com.metamatrix.connector.jdbc.util.JDBCExecutionHelper;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.SynchQueryExecution;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCQueryExecution
extends JDBCBaseExecution
implements SynchQueryExecution {
    protected int maxBatchSize = -1;
    protected ResultSet results;
    protected Class[] columnDataTypes;
    private TranslatedCommand translatedComm;

    public JDBCQueryExecution(Connection connection, SQLTranslator sqlTranslator, ResultsTranslator resultsTranslator, ConnectorLogger logger, Properties props, ExecutionContext context) {
        super(connection, sqlTranslator, resultsTranslator, logger, props, context);
    }

    public void execute(IQuery command, int maxBatchSize) throws ConnectorException {
        block5: {
            TranslatedCommand translatedComm;
            this.command = command;
            this.maxBatchSize = maxBatchSize;
            this.columnDataTypes = JDBCExecutionHelper.getColumnDataTypes((ICommand)command);
            this.translatedComm = translatedComm = this.translateCommand((ICommand)command);
            String sql = translatedComm.getSql();
            if (translatedComm.isLargeSetQuery()) {
                sql = translatedComm.nextLargeSetQuerySQL();
                this.logger.logDetail("Source-specific large-set query: " + sql);
            }
            try {
                if (translatedComm.getStatementType() == 0) {
                    this.results = this.getStatement().executeQuery(sql);
                    break block5;
                }
                if (translatedComm.getStatementType() == 1) {
                    this.results = this.getPreparedStatement(sql).executeQuery();
                    break block5;
                }
                throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSynchExecution.Statement_type_not_support_for_command_1", (Object)new Integer(translatedComm.getStatementType()), (Object)sql));
            }
            catch (SQLException e) {
                this.close();
                this.logger.logError(JDBCPlugin.Util.getString("JDBCQueryExecution.Error_executing_query__1", (Object)sql));
                throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
            }
        }
    }

    public Batch nextBatch() throws ConnectorException {
        if (!this.translatedComm.isLargeSetQuery()) {
            return JDBCExecutionHelper.createBatch(this.results, this.columnDataTypes, this.maxBatchSize, this.trimString, this.resultsTranslator, this.context);
        }
        BasicBatch batch = new BasicBatch();
        JDBCExecutionHelper.fillBatch((Batch)batch, this.results, this.columnDataTypes, this.maxBatchSize, this.trimString, this.resultsTranslator, this.context);
        while (batch.getRowCount() < this.maxBatchSize) {
            String nextQuery = null;
            nextQuery = this.translatedComm.nextLargeSetQuerySQL();
            if (nextQuery != null) {
                this.logger.logDetail("Source-specific large-set query: " + nextQuery);
                try {
                    this.close();
                    this.getPreparedStatement(nextQuery).execute();
                    this.results = this.statement.getResultSet();
                    JDBCExecutionHelper.fillBatch((Batch)batch, this.results, this.columnDataTypes, this.maxBatchSize, this.trimString, this.resultsTranslator, this.context);
                    continue;
                }
                catch (SQLException e) {
                    this.logger.logError(e.getMessage());
                    throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
                }
            }
            batch.setLast();
            break;
        }
        return batch;
    }

    public synchronized void close() throws ConnectorException {
        if (this.results != null) {
            try {
                this.results.close();
                this.results = null;
            }
            catch (SQLException e) {
                this.logger.logError(e.getMessage());
                throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
            }
        }
        super.close();
    }
}

