/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.JDBCSourceConnection;
import com.metamatrix.connector.jdbc.JDBCSourceConnectionFactory;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.Connector;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.monitor.AliveStatus;
import com.metamatrix.data.monitor.ConnectionStatus;
import com.metamatrix.data.monitor.MonitoredConnector;
import com.metamatrix.data.pool.ConnectionPool;
import com.metamatrix.data.pool.ConnectionPoolException;
import com.metamatrix.data.pool.SourceConnectionFactory;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.license.exception.LicenseException;
import java.util.Properties;

public class JDBCConnector
implements Connector,
MonitoredConnector {
    protected ConnectorEnvironment environment;
    private ConnectorLogger logger;
    private ConnectionPool pool;
    private JDBCSourceConnectionFactory factory;
    private String deregisterDriver;
    private boolean initializedClean = false;

    public void initialize(ConnectorEnvironment environment) throws ConnectorException {
        this.logger = environment.getLogger();
        this.environment = environment;
        try {
            LicenseChecker.checkProductLicense((String)"MetaMatrix DQP/Connector/JDBC", (String)"4.3", (boolean)false);
        }
        catch (LicenseException e) {
            Object[] params = new Object[]{"MetaMatrix DQP/Connector/JDBC"};
            String msg = JDBCPlugin.Util.getString("JDBCConnector.No_license_found_for_{0}", params);
            ConnectorException ce = new ConnectorException((Throwable)e, msg);
            this.logger.logError(msg, (Throwable)ce);
            throw ce;
        }
        Properties props = environment.getProperties();
        this.deregisterDriver = props.getProperty("deregisterDriver");
        this.logger.logInfo(JDBCPlugin.Util.getString("JDBCConnector.JDBCConnector_initialized._1"));
        this.logger.logTrace("Connector init properties: " + environment.getProperties());
    }

    public void stop() {
        this.cleanUp();
        this.logger.logInfo(JDBCPlugin.Util.getString("JDBCConnector.JDBCConnector_stopped._3"));
    }

    public void cleanUp() {
        if (this.pool != null) {
            this.pool.shutDown();
            this.pool = null;
        }
        if (this.deregisterDriver != null && this.factory != null) {
            this.factory.shutdown();
        }
    }

    public void start() throws ConnectorException {
        if (this.pool == null) {
            String scfClassName = this.environment.getProperties().getProperty("ExtensionConnectionFactoryClass", "com.metamatrix.connector.jdbc.JDBCSingleIdentityConnectionFactory");
            try {
                Class<?> scfClass = this.getClass().getClassLoader().loadClass(scfClassName);
                this.factory = (JDBCSourceConnectionFactory)scfClass.newInstance();
                this.factory.initialize(this.environment);
                this.pool = new ConnectionPool((SourceConnectionFactory)this.factory);
                this.pool.initialize(this.environment.getProperties());
                this.initializedClean = true;
            }
            catch (ClassNotFoundException e1) {
                throw new ConnectorException((Throwable)e1);
            }
            catch (InstantiationException e2) {
                throw new ConnectorException((Throwable)e2);
            }
            catch (IllegalAccessException e3) {
                throw new ConnectorException((Throwable)e3);
            }
            catch (ConnectionPoolException e4) {
                throw new ConnectorException((Throwable)e4);
            }
            catch (ConnectorException e5) {
                this.cleanUp();
                throw e5;
            }
        }
        this.logger.logInfo(JDBCPlugin.Util.getString("JDBCConnector.JDBCConnector_started._4"));
    }

    public Connection getConnection(SecurityContext context) throws ConnectorException {
        JDBCSourceConnection conn = (JDBCSourceConnection)this.pool.obtain(context);
        conn.setConnectionPool(this.pool);
        return conn;
    }

    public ConnectionStatus getStatus() {
        if (this.pool != null) {
            ConnectionStatus status = this.pool.getStatus();
            if (status.aliveStatus == AliveStatus.UNKNOWN && !this.initializedClean) {
                status.aliveStatus = AliveStatus.DEAD;
            }
            return status;
        }
        return new ConnectionStatus(AliveStatus.DEAD);
    }
}

