/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionItemImpl;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.uuid.UUID;

class InternalVersionImpl
extends InternalVersionItemImpl
implements InternalVersion {
    private Calendar created;
    private HashSet labelCache = null;
    private final boolean isRoot;
    private final QName name;
    private final InternalVersionHistory versionHistory;

    public InternalVersionImpl(InternalVersionHistoryImpl vh, NodeStateEx node, QName name) {
        super(vh.getVersionManager(), node);
        this.versionHistory = vh;
        this.name = name;
        InternalValue[] values = node.getPropertyValues(QName.JCR_CREATED);
        if (values != null) {
            this.created = (Calendar)values[0].internalValue();
        }
        this.isRoot = name.equals((Object)QName.JCR_ROOTVERSION);
    }

    public NodeId getId() {
        return this.node.getNodeId();
    }

    public InternalVersionItem getParent() {
        return this.versionHistory;
    }

    public QName getName() {
        return this.name;
    }

    public InternalFrozenNode getFrozenNode() {
        try {
            NodeState.ChildNodeEntry entry = this.node.getState().getChildNodeEntry(QName.JCR_FROZENNODE, 1);
            if (entry == null) {
                throw new InternalError("version has no frozen node: " + this.getId());
            }
            return (InternalFrozenNode)this.vMgr.getItem(entry.getId());
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("unable to retrieve frozen node: " + (Object)((Object)e));
        }
    }

    public Calendar getCreated() {
        return this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalVersion[] getSuccessors() {
        this.vMgr.acquireReadLock();
        try {
            InternalValue[] values = this.node.getPropertyValues(QName.JCR_SUCCESSORS);
            if (values != null) {
                InternalVersion[] versions = new InternalVersion[values.length];
                for (int i = 0; i < values.length; ++i) {
                    NodeId vId = new NodeId((UUID)values[i].internalValue());
                    versions[i] = this.versionHistory.getVersion(vId);
                }
                InternalVersion[] internalVersionArray = versions;
                return internalVersionArray;
            }
            InternalVersion[] internalVersionArray = new InternalVersion[]{};
            return internalVersionArray;
        }
        finally {
            this.vMgr.releaseReadLock();
        }
    }

    public InternalVersion[] getPredecessors() {
        InternalValue[] values = this.node.getPropertyValues(QName.JCR_PREDECESSORS);
        if (values != null) {
            InternalVersion[] versions = new InternalVersion[values.length];
            for (int i = 0; i < values.length; ++i) {
                NodeId vId = new NodeId((UUID)values[i].internalValue());
                versions[i] = this.versionHistory.getVersion(vId);
            }
            return versions;
        }
        return new InternalVersion[0];
    }

    public boolean isMoreRecent(InternalVersion v) {
        InternalVersion[] preds = this.getPredecessors();
        for (int i = 0; i < preds.length; ++i) {
            InternalVersion pred = preds[i];
            if (!pred.equals(v) && !pred.isMoreRecent(v)) continue;
            return true;
        }
        return false;
    }

    public InternalVersionHistory getVersionHistory() {
        return this.versionHistory;
    }

    public boolean hasLabel(QName label) {
        return this.internalHasLabel(label);
    }

    public QName[] getLabels() {
        return this.internalGetLabels();
    }

    public boolean isRootVersion() {
        return this.isRoot;
    }

    void clear() {
        this.labelCache = null;
    }

    private void storeXCessors(List cessors, QName propname, boolean store) throws RepositoryException {
        InternalValue[] values = new InternalValue[cessors.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = InternalValue.create(((InternalVersion)cessors.get(i)).getId().getUUID());
        }
        this.node.setPropertyValues(propname, 1, values);
        if (store) {
            this.node.store();
        }
    }

    void internalDetach() throws RepositoryException {
        InternalVersion[] succ = this.getSuccessors();
        for (int i = 0; i < succ.length; ++i) {
            ((InternalVersionImpl)succ[i]).internalDetachPredecessor(this, true);
        }
        InternalVersion[] preds = this.getPredecessors();
        for (int i = 0; i < preds.length; ++i) {
            ((InternalVersionImpl)preds[i]).internalDetachSuccessor(this, true);
        }
        this.clear();
    }

    void internalAttach() throws RepositoryException {
        InternalVersion[] preds = this.getPredecessors();
        for (int i = 0; i < preds.length; ++i) {
            ((InternalVersionImpl)preds[i]).internalAddSuccessor(this, true);
        }
    }

    private void internalAddSuccessor(InternalVersionImpl succ, boolean store) throws RepositoryException {
        ArrayList<InternalVersion> l = new ArrayList<InternalVersion>(Arrays.asList(this.getSuccessors()));
        if (!l.contains(succ)) {
            l.add(succ);
            this.storeXCessors(l, QName.JCR_SUCCESSORS, store);
        }
    }

    private void internalDetachPredecessor(InternalVersionImpl v, boolean store) throws RepositoryException {
        ArrayList<InternalVersion> l = new ArrayList<InternalVersion>(Arrays.asList(this.getPredecessors()));
        l.remove(v);
        l.addAll(Arrays.asList(v.getPredecessors()));
        this.storeXCessors(l, QName.JCR_PREDECESSORS, store);
    }

    private void internalDetachSuccessor(InternalVersionImpl v, boolean store) throws RepositoryException {
        ArrayList<InternalVersion> l = new ArrayList<InternalVersion>(Arrays.asList(this.getSuccessors()));
        l.remove(v);
        l.addAll(Arrays.asList(v.getSuccessors()));
        this.storeXCessors(l, QName.JCR_SUCCESSORS, store);
    }

    boolean internalAddLabel(QName label) {
        if (this.labelCache == null) {
            this.labelCache = new HashSet();
        }
        return this.labelCache.add(label);
    }

    boolean internalRemoveLabel(QName label) {
        if (this.labelCache == null) {
            return false;
        }
        return this.labelCache.remove(label);
    }

    boolean internalHasLabel(QName label) {
        if (this.labelCache == null) {
            return false;
        }
        return this.labelCache.contains(label);
    }

    QName[] internalGetLabels() {
        if (this.labelCache == null) {
            return new QName[0];
        }
        return this.labelCache.toArray(new QName[this.labelCache.size()]);
    }

    void invalidate() {
        this.node.getState().discard();
    }

    void legacyResolveSuccessors() throws RepositoryException {
        InternalValue[] values = this.node.getPropertyValues(QName.JCR_PREDECESSORS);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                NodeId vId = new NodeId((UUID)values[i].internalValue());
                InternalVersionImpl v = (InternalVersionImpl)this.versionHistory.getVersion(vId);
                v.internalAddSuccessor(this, false);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InternalVersionImpl) {
            InternalVersionImpl v = (InternalVersionImpl)obj;
            return v.getId().equals(this.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

