/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUItemStateCache
implements ItemStateCache {
    private static Logger log = LoggerFactory.getLogger((Class)LRUItemStateCache.class);
    public static final int DEFAULT_MAX_SIZE = 1000;
    private final LRUMap cache;

    public LRUItemStateCache() {
        this(1000);
    }

    public LRUItemStateCache(int maxSize) {
        this.cache = new LRUMap(maxSize, true);
    }

    public boolean isCached(ItemId id) {
        return this.cache.containsKey((Object)id);
    }

    public ItemState retrieve(ItemId id) {
        return (ItemState)this.cache.get((Object)id);
    }

    public void cache(ItemState state) {
        ItemId id = state.getId();
        if (this.cache.containsKey((Object)id)) {
            log.warn("overwriting cached entry " + id);
        }
        this.cache.put((Object)id, (Object)state);
    }

    public void evict(ItemId id) {
        this.cache.remove((Object)id);
    }

    public void evictAll() {
        this.cache.clear();
    }

    public void update(ItemId id) {
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public int size() {
        return this.cache.size();
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.cache.keySet());
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.cache.values());
    }

    public void dispose() {
        this.cache.clear();
    }
}

