/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.core.query.DefaultQueryNodeVisitor;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.LocationStepQueryNode;
import org.apache.jackrabbit.core.query.NodeTypeQueryNode;
import org.apache.jackrabbit.core.query.OrderQueryNode;
import org.apache.jackrabbit.core.query.PathQueryNode;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.QueryParser;
import org.apache.jackrabbit.core.query.QueryRootNode;
import org.apache.jackrabbit.core.query.lucene.LazyQueryResultImpl;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryBuilder;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.WorkspaceTraversalResult;
import org.apache.jackrabbit.name.QName;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements ExecutableQuery {
    private static final Logger log = LoggerFactory.getLogger((Class)QueryImpl.class);
    protected static final QueryRootNode ALL_NODES = new QueryRootNode();
    protected final QueryRootNode root;
    protected final SessionImpl session;
    protected final ItemManager itemMgr;
    protected final SearchIndex index;
    protected final PropertyTypeRegistry propReg;
    private boolean documentOrder = true;

    public QueryImpl(SessionImpl session, ItemManager itemMgr, SearchIndex index, PropertyTypeRegistry propReg, String statement, String language) throws InvalidQueryException {
        this.session = session;
        this.itemMgr = itemMgr;
        this.index = index;
        this.propReg = propReg;
        this.root = QueryParser.parse(statement, language, session.getNamespaceResolver());
    }

    public QueryResult execute() throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug("Executing query: \n" + this.root.dump());
        }
        if (ALL_NODES.equals(this.root)) {
            return new WorkspaceTraversalResult(this.session, new QName[]{QName.JCR_PRIMARYTYPE, QName.JCR_PATH, QName.JCR_SCORE}, this.session.getNamespaceResolver());
        }
        Query query = LuceneQueryBuilder.createQuery(this.root, this.session, this.index.getContext().getItemStateManager(), this.index.getNamespaceMappings(), this.index.getTextAnalyzer(), this.propReg);
        OrderQueryNode orderNode = this.root.getOrderNode();
        OrderQueryNode.OrderSpec[] orderSpecs = orderNode != null ? orderNode.getOrderSpecs() : new OrderQueryNode.OrderSpec[]{};
        QName[] orderProperties = new QName[orderSpecs.length];
        boolean[] ascSpecs = new boolean[orderSpecs.length];
        for (int i = 0; i < orderSpecs.length; ++i) {
            orderProperties[i] = orderSpecs[i].getProperty();
            ascSpecs[i] = orderSpecs[i].isAscending();
        }
        return new LazyQueryResultImpl(this.index, this.itemMgr, this.session.getNamespaceResolver(), this.session.getAccessManager(), this, query, this.getSelectProperties(), orderProperties, ascSpecs, this.documentOrder);
    }

    public boolean getRespectDocumentOrder() {
        return this.documentOrder;
    }

    public void setRespectDocumentOrder(boolean documentOrder) {
        this.documentOrder = documentOrder;
    }

    protected QName[] getSelectProperties() throws RepositoryException {
        ArrayList<QName> selectProps = new ArrayList<QName>();
        selectProps.addAll(Arrays.asList(this.root.getSelectProperties()));
        if (selectProps.size() == 0) {
            LocationStepQueryNode[] steps = this.root.getLocationNode().getPathSteps();
            final QName[] ntName = new QName[1];
            steps[steps.length - 1].acceptOperands(new DefaultQueryNodeVisitor(){

                public Object visit(NodeTypeQueryNode node, Object data) {
                    ntName[0] = node.getValue();
                    return data;
                }
            }, null);
            if (ntName[0] == null) {
                ntName[0] = QName.NT_BASE;
            }
            NodeTypeImpl nt = this.session.getNodeTypeManager().getNodeType(ntName[0]);
            PropertyDefinition[] propDefs = nt.getPropertyDefinitions();
            for (int i = 0; i < propDefs.length; ++i) {
                PropertyDefinitionImpl propDef = (PropertyDefinitionImpl)propDefs[i];
                if (propDef.definesResidual() || propDef.isMultiple()) continue;
                selectProps.add(propDef.getQName());
            }
        }
        if (!selectProps.contains(QName.JCR_PATH)) {
            selectProps.add(QName.JCR_PATH);
        }
        if (!selectProps.contains(QName.JCR_SCORE)) {
            selectProps.add(QName.JCR_SCORE);
        }
        return selectProps.toArray(new QName[selectProps.size()]);
    }

    static {
        PathQueryNode pathNode = new PathQueryNode(ALL_NODES);
        pathNode.addPathStep(new LocationStepQueryNode(pathNode, null, true));
        pathNode.setAbsolute(true);
        ALL_NODES.setLocationNode(pathNode);
    }
}

