/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import javax.jcr.NamespaceException;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.name.AbstractNamespaceResolver;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;

public class NSRegistryBasedNamespaceMappings
extends AbstractNamespaceResolver
implements NamespaceMappings {
    private final NamespaceRegistryImpl nsReg;

    NSRegistryBasedNamespaceMappings(NamespaceRegistryImpl nsReg) {
        this.nsReg = nsReg;
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            int index = Integer.parseInt(prefix);
            return this.nsReg.getURI(index);
        }
        catch (NumberFormatException e) {
            throw new NamespaceException("Unknown prefix: " + prefix);
        }
    }

    public String getPrefix(String uri) throws NamespaceException {
        return String.valueOf(this.nsReg.getURIIndex(uri));
    }

    public String translatePropertyName(String name, NamespaceResolver resolver) throws IllegalNameException, UnknownPrefixException {
        QName qName = NameFormat.parse((String)name, (NamespaceResolver)resolver);
        try {
            return NameFormat.format((QName)qName, (NamespaceResolver)this);
        }
        catch (NoPrefixDeclaredException e) {
            throw new IllegalNameException("Internal error.", (Throwable)e);
        }
    }
}

