/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.Constants;

class FSDirectory
extends Directory {
    private static final boolean DISABLE_LOCKS = Boolean.getBoolean("disableLuceneLocks") || Constants.JAVA_1_1;
    private final org.apache.lucene.store.FSDirectory delegatee;
    private final File directory;
    private int refCount = 0;
    private static final Map directories = new HashMap();

    private FSDirectory(org.apache.lucene.store.FSDirectory delegatee, File directory) {
        this.delegatee = delegatee;
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSDirectory getDirectory(File file, boolean create) throws IOException {
        FSDirectory dir;
        Object object = directories;
        synchronized (object) {
            dir = (FSDirectory)((Object)directories.get(file.getCanonicalPath()));
            if (dir == null) {
                dir = new FSDirectory(org.apache.lucene.store.FSDirectory.getDirectory((File)file, (boolean)create), file);
                directories.put(file.getCanonicalPath(), dir);
            }
        }
        object = dir;
        synchronized (object) {
            ++dir.refCount;
        }
        return dir;
    }

    public Lock makeLock(String name) {
        final File lockFile = new File(this.directory, name);
        return new Lock(){

            public boolean obtain() throws IOException {
                if (DISABLE_LOCKS) {
                    return true;
                }
                return lockFile.createNewFile();
            }

            public void release() {
                if (DISABLE_LOCKS) {
                    return;
                }
                lockFile.delete();
            }

            public boolean isLocked() {
                if (DISABLE_LOCKS) {
                    return false;
                }
                return lockFile.exists();
            }

            public String toString() {
                return "Lock@" + lockFile;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        this.delegatee.close();
        if (--this.refCount <= 0) {
            Map map = directories;
            synchronized (map) {
                directories.remove(this.directory.getCanonicalPath());
            }
        }
    }

    public IndexOutput createOutput(String name) throws IOException {
        return this.delegatee.createOutput(name);
    }

    public void deleteFile(String name) throws IOException {
        this.delegatee.deleteFile(name);
    }

    public boolean fileExists(String name) throws IOException {
        return this.delegatee.fileExists(name);
    }

    public long fileLength(String name) throws IOException {
        return this.delegatee.fileLength(name);
    }

    public long fileModified(String name) throws IOException {
        return this.delegatee.fileModified(name);
    }

    public String[] list() throws IOException {
        return this.delegatee.list();
    }

    public IndexInput openInput(String name) throws IOException {
        return this.delegatee.openInput(name);
    }

    public void renameFile(String from, String to) throws IOException {
        this.delegatee.renameFile(from, to);
    }

    public void touchFile(String name) throws IOException {
        this.delegatee.touchFile(name);
    }
}

