/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import org.apache.jackrabbit.core.query.QueryNode;
import org.apache.jackrabbit.core.query.QueryNodeVisitor;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.QName;

public class TextsearchQueryNode
extends QueryNode {
    private final String query;
    private Path relPath;
    private boolean propertyRef;

    public TextsearchQueryNode(QueryNode parent, String query) {
        this(parent, query, null, false);
    }

    public TextsearchQueryNode(QueryNode parent, String query, Path relPath, boolean isProperty) {
        super(parent);
        this.query = query;
        this.relPath = relPath;
        this.propertyRef = isProperty;
    }

    public Object accept(QueryNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public int getType() {
        return 4;
    }

    public String getQuery() {
        return this.query;
    }

    public QName getPropertyName() {
        return this.relPath == null ? null : this.relPath.getNameElement().getName();
    }

    public void setPropertyName(QName property) {
        Path.PathBuilder builder = new Path.PathBuilder();
        builder.addLast(property);
        try {
            this.relPath = builder.getPath();
            this.propertyRef = true;
        }
        catch (MalformedPathException malformedPathException) {
            // empty catch block
        }
    }

    public Path getRelativePath() {
        return this.relPath;
    }

    public void setRelativePath(Path relPath) {
        if (relPath != null && relPath.isAbsolute()) {
            throw new IllegalArgumentException("relPath must be relative");
        }
        this.relPath = relPath;
        if (relPath == null) {
            this.propertyRef = false;
        }
    }

    public void addPathElement(Path.PathElement element) {
        Path.PathBuilder builder = new Path.PathBuilder();
        if (this.relPath != null) {
            builder.addAll(this.relPath.getElements());
        }
        builder.addLast(element);
        try {
            this.relPath = builder.getPath();
        }
        catch (MalformedPathException malformedPathException) {
            // empty catch block
        }
    }

    public boolean getReferencesProperty() {
        return this.propertyRef;
    }

    public void setReferencesProperty(boolean b) {
        this.propertyRef = b;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextsearchQueryNode) {
            TextsearchQueryNode other = (TextsearchQueryNode)obj;
            return (this.query == null ? other.query == null : this.query.equals(other.query)) && (this.relPath == null ? other.relPath == null : this.relPath.equals((Object)other.relPath) && this.propertyRef == other.propertyRef);
        }
        return false;
    }
}

