/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.lock;

import javax.jcr.Session;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.lock.LockToken;

public abstract class AbstractLockInfo {
    protected final LockToken lockToken;
    protected final boolean sessionScoped;
    protected final boolean deep;
    protected final String lockOwner;
    protected SessionImpl lockHolder;
    protected boolean live;

    public AbstractLockInfo(LockToken lockToken, boolean sessionScoped, boolean deep, String lockOwner) {
        this.lockToken = lockToken;
        this.sessionScoped = sessionScoped;
        this.deep = deep;
        this.lockOwner = lockOwner;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public NodeId getId() {
        return this.lockToken.id;
    }

    public SessionImpl getLockHolder() {
        return this.lockHolder;
    }

    public void setLockHolder(SessionImpl lockHolder) {
        this.lockHolder = lockHolder;
    }

    public String getLockToken(Session session) {
        if (session.equals(this.lockHolder)) {
            return this.lockToken.toString();
        }
        return null;
    }

    public boolean isLive() {
        return this.live;
    }

    public boolean mayChange() {
        return this.live;
    }

    public boolean isSessionScoped() {
        return this.sessionScoped;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        if (this.deep) {
            buffer.append("deep ");
        }
        if (this.sessionScoped) {
            buffer.append("session ");
        }
        buffer.append("holder:");
        if (this.lockHolder != null) {
            buffer.append(this.lockHolder.getUserID());
        } else {
            buffer.append("none");
        }
        buffer.append(')');
        return buffer.toString();
    }
}

