/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.cluster.ClusterContext;
import org.apache.jackrabbit.core.cluster.ClusterException;
import org.apache.jackrabbit.core.cluster.ItemOperation;
import org.apache.jackrabbit.core.cluster.Journal;
import org.apache.jackrabbit.core.cluster.JournalException;
import org.apache.jackrabbit.core.cluster.LockEventChannel;
import org.apache.jackrabbit.core.cluster.LockEventListener;
import org.apache.jackrabbit.core.cluster.NamespaceEventChannel;
import org.apache.jackrabbit.core.cluster.NamespaceEventListener;
import org.apache.jackrabbit.core.cluster.NodeTypeEventChannel;
import org.apache.jackrabbit.core.cluster.NodeTypeEventListener;
import org.apache.jackrabbit.core.cluster.RecordProcessor;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.cluster.UpdateEventListener;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNode
implements Runnable,
UpdateEventChannel,
NamespaceEventChannel,
NodeTypeEventChannel {
    public static final String SYSTEM_PROPERTY_NODE_ID = "org.apache.jackrabbit.core.cluster.node_id";
    private static final String SHORT_PADDING = "0000";
    private static final int NONE = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private static Logger log = LoggerFactory.getLogger((Class)ClusterNode.class);
    private ClusterContext clusterContext;
    private String clusterNodeId;
    private int syncDelay;
    private Journal journal;
    private final Mutex syncLock = new Mutex();
    private int status;
    private final Map wspLockListeners = new HashMap();
    private final Map wspUpdateListeners = new HashMap();
    private UpdateEventListener versionUpdateListener;
    private NamespaceEventListener namespaceListener;
    private NodeTypeEventListener nodeTypeListener;

    public void init(ClusterContext clusterContext) throws ClusterException {
        this.clusterContext = clusterContext;
        this.init();
    }

    protected void init() throws ClusterException {
        ClusterConfig cc = this.clusterContext.getClusterConfig();
        this.clusterNodeId = this.getClusterNodeId(cc.getId());
        this.syncDelay = cc.getSyncDelay();
        try {
            this.journal = (Journal)cc.getJournalConfig().newInstance();
            this.journal.init(this.clusterNodeId, new SyncListener(), this.clusterContext.getNamespaceResovler());
        }
        catch (ConfigurationException e) {
            throw new ClusterException(e.getMessage(), e.getCause());
        }
    }

    public synchronized void start() throws ClusterException {
        if (this.status == 0) {
            this.sync();
            Thread t = new Thread((Runnable)this, "ClusterNode-" + this.clusterNodeId);
            t.setDaemon(true);
            t.start();
            this.status = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            String msg;
            ClusterNode clusterNode = this;
            synchronized (clusterNode) {
                try {
                    this.wait(this.syncDelay * 1000);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.status == 2) {
                    return;
                }
            }
            try {
                this.sync();
                continue;
            }
            catch (ClusterException e) {
                msg = "Periodic sync of journal failed: " + e.getMessage();
                log.error(msg);
                continue;
            }
            catch (Exception e) {
                msg = "Unexpected error while syncing of journal: " + e.getMessage();
                log.error(msg, (Throwable)e);
                continue;
            }
            catch (Error e) {
                msg = "Unexpected error while syncing of journal: " + e.getMessage();
                log.error(msg, (Throwable)e);
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws ClusterException {
        try {
            this.syncLock.acquire();
        }
        catch (InterruptedException e) {
            String msg = "Interrupted while waiting for mutex.";
            throw new ClusterException(msg);
        }
        try {
            this.journal.sync();
        }
        finally {
            this.syncLock.release();
        }
    }

    public synchronized void stop() {
        if (this.status == 1) {
            this.status = 2;
            this.journal.close();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locked(String workspace, NodeId nodeId, boolean deep, String owner) {
        if (this.status != 1) {
            log.info("not started: lock operation ignored.");
            return;
        }
        boolean succeeded = false;
        try {
            this.journal.begin(workspace);
            this.journal.log(nodeId, deep, owner);
            this.journal.prepare();
            this.journal.commit();
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded) {
                this.journal.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlocked(String workspace, NodeId nodeId) {
        if (this.status != 1) {
            log.info("not started: unlock operation ignored.");
            return;
        }
        boolean succeeded = false;
        try {
            this.journal.begin(workspace);
            this.journal.log(nodeId);
            this.journal.prepare();
            this.journal.commit();
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded) {
                this.journal.cancel();
            }
        }
    }

    public UpdateEventChannel createUpdateChannel(String workspace) {
        return new WorkspaceUpdateChannel(workspace);
    }

    public LockEventChannel createLockChannel(String workspace) {
        return new WorkspaceLockChannel(workspace);
    }

    private String getClusterNodeId(String id) {
        if (id == null && (id = System.getProperty(SYSTEM_PROPERTY_NODE_ID)) == null) {
            id = ClusterNode.toHexString((short)(Math.random() * 65535.0));
        }
        return id;
    }

    private static String toHexString(short n) {
        String s = Integer.toHexString(n);
        int padlen = SHORT_PADDING.length() - s.length();
        if (padlen < 0) {
            s = s.substring(-padlen);
        } else if (padlen > 0) {
            s = SHORT_PADDING.substring(0, padlen) + s;
        }
        return s;
    }

    public void updateCreated() {
        if (this.status != 1) {
            log.info("not started: update create ignored.");
            return;
        }
        try {
            this.sync();
        }
        catch (ClusterException e) {
            String msg = "Unable to sync with journal: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
    }

    public void updatePrepared(ChangeLog changes, EventStateCollection esc) {
        this.updatePrepared(null, changes, esc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePrepared(String workspace, ChangeLog changes, EventStateCollection esc) {
        if (this.status != 1) {
            log.info("not started: update prepare ignored.");
            return;
        }
        boolean succeeded = false;
        try {
            this.journal.begin(workspace);
            this.journal.log(changes, esc);
            this.journal.prepare();
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while preparing log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded) {
                this.journal.cancel();
            }
        }
    }

    public void updateCommitted() {
        if (this.status != 1) {
            log.info("not started: update commit ignored.");
            return;
        }
        try {
            this.journal.commit();
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while committing log entry.";
            log.error(msg, e);
        }
    }

    public void updateCancelled() {
        if (this.status != 1) {
            log.info("not started: update cancel ignored.");
            return;
        }
        this.journal.cancel();
    }

    public void setListener(UpdateEventListener listener) {
        this.versionUpdateListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remapped(String oldPrefix, String newPrefix, String uri) {
        if (this.status != 1) {
            log.info("not started: namespace operation ignored.");
            return;
        }
        boolean succeeded = false;
        try {
            this.journal.begin(null);
            this.journal.log(oldPrefix, newPrefix, uri);
            this.journal.prepare();
            this.journal.commit();
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded) {
                this.journal.cancel();
            }
        }
    }

    public void setListener(NamespaceEventListener listener) {
        this.namespaceListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registered(Collection ntDefs) {
        if (this.status != 1) {
            log.info("not started: nodetype operation ignored.");
            return;
        }
        boolean succeeded = false;
        try {
            this.journal.begin(null);
            this.journal.log(ntDefs);
            this.journal.prepare();
            this.journal.commit();
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded) {
                this.journal.cancel();
            }
        }
    }

    public void setListener(NodeTypeEventListener listener) {
        this.nodeTypeListener = listener;
    }

    class SyncListener
    implements RecordProcessor {
        private String workspace;
        private ChangeLog changeLog;
        private List events;

        SyncListener() {
        }

        public void start(String workspace) {
            this.workspace = workspace;
            this.changeLog = new ChangeLog();
            this.events = new ArrayList();
        }

        public void process(ItemOperation operation) {
            operation.apply(this.changeLog);
        }

        public void process(EventState event) {
            this.events.add(event);
        }

        public void process(NodeId nodeId, boolean isDeep, String owner) {
            String msg;
            LockEventListener listener = (LockEventListener)ClusterNode.this.wspLockListeners.get(this.workspace);
            if (listener == null) {
                try {
                    ClusterNode.this.clusterContext.lockEventsReady(this.workspace);
                }
                catch (RepositoryException e) {
                    msg = "Unable to make lock listener for workspace " + this.workspace + " online: " + e.getMessage();
                    log.warn(msg);
                }
                listener = (LockEventListener)ClusterNode.this.wspLockListeners.get(this.workspace);
                if (listener == null) {
                    String msg2 = "Lock channel unavailable for workspace: " + this.workspace;
                    log.error(msg2);
                    return;
                }
            }
            try {
                listener.externalLock(nodeId, isDeep, owner);
            }
            catch (RepositoryException e) {
                msg = "Unable to deliver lock event: " + e.getMessage();
                log.error(msg);
            }
        }

        public void process(NodeId nodeId) {
            String msg;
            LockEventListener listener = (LockEventListener)ClusterNode.this.wspLockListeners.get(this.workspace);
            if (listener == null) {
                try {
                    ClusterNode.this.clusterContext.lockEventsReady(this.workspace);
                }
                catch (RepositoryException e) {
                    msg = "Unable to make lock listener for workspace " + this.workspace + " online: " + e.getMessage();
                    log.warn(msg);
                }
                listener = (LockEventListener)ClusterNode.this.wspLockListeners.get(this.workspace);
                if (listener == null) {
                    String msg2 = "Lock channel unavailable for workspace: " + this.workspace;
                    log.error(msg2);
                    return;
                }
            }
            try {
                listener.externalUnlock(nodeId);
            }
            catch (RepositoryException e) {
                msg = "Unable to deliver lock event: " + e.getMessage();
                log.error(msg);
            }
        }

        public void process(String oldPrefix, String newPrefix, String uri) {
            if (ClusterNode.this.namespaceListener == null) {
                String msg = "Namespace listener unavailable.";
                log.error(msg);
                return;
            }
            try {
                ClusterNode.this.namespaceListener.externalRemap(oldPrefix, newPrefix, uri);
            }
            catch (RepositoryException e) {
                String msg = "Unable to deliver namespace operation: " + e.getMessage();
                log.error(msg);
            }
        }

        public void process(Collection ntDefs) {
            if (ClusterNode.this.nodeTypeListener == null) {
                String msg = "NodeType listener unavailable.";
                log.error(msg);
                return;
            }
            try {
                ClusterNode.this.nodeTypeListener.externalRegistered(ntDefs);
            }
            catch (InvalidNodeTypeDefException e) {
                String msg = "Unable to deliver node type operation: " + e.getMessage();
                log.error(msg);
            }
            catch (RepositoryException e) {
                String msg = "Unable to deliver node type operation: " + e.getMessage();
                log.error(msg);
            }
        }

        public void end() {
            String msg;
            UpdateEventListener listener = null;
            if (this.workspace != null) {
                listener = (UpdateEventListener)ClusterNode.this.wspUpdateListeners.get(this.workspace);
                if (listener == null) {
                    try {
                        ClusterNode.this.clusterContext.updateEventsReady(this.workspace);
                    }
                    catch (RepositoryException e) {
                        msg = "Error making update listener for workspace " + this.workspace + " online: " + e.getMessage();
                        log.warn(msg);
                    }
                    listener = (UpdateEventListener)ClusterNode.this.wspUpdateListeners.get(this.workspace);
                    if (listener == null) {
                        String msg2 = "Update listener unavailable for workspace: " + this.workspace;
                        log.error(msg2);
                        return;
                    }
                }
            } else if (ClusterNode.this.versionUpdateListener != null) {
                listener = ClusterNode.this.versionUpdateListener;
            } else {
                String msg3 = "Version update listener unavailable.";
                log.error(msg3);
                return;
            }
            try {
                listener.externalUpdate(this.changeLog, this.events);
            }
            catch (RepositoryException e) {
                msg = "Unable to deliver update events: " + e.getMessage();
                log.error(msg);
            }
        }
    }

    class WorkspaceLockChannel
    implements LockEventChannel {
        private final String workspace;

        public WorkspaceLockChannel(String workspace) {
            this.workspace = workspace;
        }

        public void locked(NodeId nodeId, boolean deep, String owner) {
            ClusterNode.this.locked(this.workspace, nodeId, deep, owner);
        }

        public void unlocked(NodeId nodeId) {
            ClusterNode.this.unlocked(this.workspace, nodeId);
        }

        public void setListener(LockEventListener listener) {
            ClusterNode.this.wspLockListeners.remove(this.workspace);
            if (listener != null) {
                ClusterNode.this.wspLockListeners.put(this.workspace, listener);
            }
        }
    }

    class WorkspaceUpdateChannel
    implements UpdateEventChannel {
        private final String workspace;

        public WorkspaceUpdateChannel(String workspace) {
            this.workspace = workspace;
        }

        public void updateCreated() {
            ClusterNode.this.updateCreated();
        }

        public void updatePrepared(ChangeLog changes, EventStateCollection esc) {
            ClusterNode.this.updatePrepared(this.workspace, changes, esc);
        }

        public void updateCommitted() {
            ClusterNode.this.updateCommitted();
        }

        public void updateCancelled() {
            ClusterNode.this.updateCancelled();
        }

        public void setListener(UpdateEventListener listener) {
            ClusterNode.this.wspUpdateListeners.remove(this.workspace);
            if (listener != null) {
                ClusterNode.this.wspUpdateListeners.put(this.workspace, listener);
            }
        }
    }
}

