/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.oracle.aq;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.jms.AQjmsFactory;
import oracle.jms.AQjmsSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.soa.esb.oracle.aq.AQUtil;
import org.jboss.soa.esb.oracle.aq.DestinationInfo;
import org.mockejb.jndi.MockContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AQInitialContextFactory
implements InitialContextFactory {
    public static final String QUEUE_CONNECTION_FACTORY = "QueueConnectionFactory";
    public static final String XA_QUEUE_CONNECTION_FACTORY = "XAQueueConnectionFactory";
    public static final String TOPIC_CONNECTION_FACTORY = "TopicConnectionFactory";
    public static final String XA_TOPIC_CONNECTION_FACTORY = "XATopicConnectionFactory";
    public static final String CONNECTION_FACTORY = "ConnectionFactory";
    public static final String XA_CONNECTION_FACTORY = "XAConnectionFactory";
    public static final String DB_DATASOURCE = "java.naming.oracle.aq.datasource";
    public static final String DB_USER = "java.naming.oracle.aq.user";
    public static final String DB_PASSWD = "java.naming.oracle.aq.password";
    public static final String DB_SERVER = "java.naming.oracle.aq.server";
    public static final String DB_INSTANCE = "java.naming.oracle.aq.instance";
    public static final String DB_PORT = "java.naming.oracle.aq.port";
    public static final String DB_SCHEMA = "java.naming.oracle.aq.schema";
    public static final String DB_DRIVER = "java.naming.oracle.aq.driver";
    public static final String DB_CONNECTION_URL = "java.naming.oracle.aq.url";
    protected static Log log = LogFactory.getLog(AQInitialContextFactory.class);
    protected Hashtable props;
    protected String dbuser;
    protected String dbpass;
    protected String aqServerName;
    protected String aqServerDBInst;
    protected String aqServerPort;
    protected String aqDBDriver;
    protected String aqSchemaName;
    protected int aqServerPortNumber = 1521;
    protected String aqConnectionUrl;

    private void addAQDestinationContext(Context context) throws NamingException {
        QueueConnection queueConnection = null;
        TopicConnection topicConnection = null;
        AQjmsSession session = null;
        try {
            DataSource ds = null;
            XADataSource xaDs = null;
            try {
                if (this.aqConnectionUrl != null) {
                    ds = AQUtil.getSQLDataSource(this.aqConnectionUrl, this.dbuser, this.dbpass);
                    xaDs = AQUtil.getXASQLDataSource(this.aqConnectionUrl, this.dbuser, this.dbpass);
                } else {
                    ds = AQUtil.getSQLDataSource(this.aqServerName, this.aqServerDBInst, this.aqServerPortNumber, this.aqDBDriver, this.dbuser, this.dbpass);
                    xaDs = AQUtil.getXASQLDataSource(this.aqServerName, this.aqServerDBInst, this.aqServerPortNumber, this.aqDBDriver, this.dbuser, this.dbpass);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage());
            }
            XAConnectionFactory factory = AQjmsFactory.getXAConnectionFactory((XADataSource)xaDs);
            context.rebind(XA_CONNECTION_FACTORY, (Object)factory);
            context.rebind("KURTSTAM", (Object)new String("hello"));
            ConnectionFactory connectionFactory = AQjmsFactory.getConnectionFactory((DataSource)ds);
            context.rebind(CONNECTION_FACTORY, (Object)connectionFactory);
            QueueConnectionFactory queueFactory = AQjmsFactory.getQueueConnectionFactory((DataSource)ds);
            context.rebind(QUEUE_CONNECTION_FACTORY, (Object)queueFactory);
            queueConnection = queueFactory.createQueueConnection();
            session = (AQjmsSession)queueConnection.createQueueSession(false, 1);
            XAQueueConnectionFactory xaQueueConnectionFactory = AQjmsFactory.getXAQueueConnectionFactory((XADataSource)xaDs);
            context.rebind(XA_QUEUE_CONNECTION_FACTORY, (Object)xaQueueConnectionFactory);
            XATopicConnectionFactory xaTopicConnectionFactory = AQjmsFactory.getXATopicConnectionFactory((XADataSource)xaDs);
            context.rebind(XA_TOPIC_CONNECTION_FACTORY, (Object)xaTopicConnectionFactory);
            TopicConnectionFactory topicFactory = AQjmsFactory.getTopicConnectionFactory((DataSource)ds);
            context.rebind(TOPIC_CONNECTION_FACTORY, (Object)topicFactory);
            topicConnection = topicFactory.createTopicConnection();
            session = (AQjmsSession)topicConnection.createTopicSession(false, 1);
            List<DestinationInfo> list = AQUtil.getDestinationInfoList(ds, this.aqSchemaName);
            for (DestinationInfo di : list) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading Destination: " + di));
                }
                this.registerDestination(context, session, di);
            }
        }
        catch (JMSException e) {
            log.error((Object)"JMSException exception", (Throwable)e);
            throw new RuntimeException("JMSException exception", e);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
                if (queueConnection != null) {
                    queueConnection.close();
                }
                if (topicConnection != null) {
                    topicConnection.close();
                }
            }
            catch (JMSException e) {
                log.error((Object)"JMSEx while cleaning up", (Throwable)e);
            }
        }
    }

    private void registerDestination(Context context, AQjmsSession session, DestinationInfo di) {
        if (di == null) {
            log.warn((Object)"Warning: registerDestination called with null DestinationInfo.");
            return;
        }
        try {
            if (di.isMultipleSubscribers()) {
                Topic topic = session.getTopic(di.getOwner(), di.getQueueName());
                context.rebind(topic.getTopicName(), (Object)topic);
            } else {
                Queue queue = session.getQueue(di.getOwner(), di.getQueueName());
                context.rebind(queue.getQueueName(), (Object)queue);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Warning.  Error while looking up destination: " + e));
        }
    }

    public void init(Hashtable<?, ?> env) {
        this.dbuser = (String)env.get(DB_USER);
        this.dbpass = (String)env.get(DB_PASSWD);
        this.aqConnectionUrl = (String)env.get(DB_CONNECTION_URL);
        if (this.aqConnectionUrl == null) {
            this.aqServerName = (String)env.get(DB_SERVER);
            this.aqServerDBInst = (String)env.get(DB_INSTANCE);
            this.aqDBDriver = (String)env.get(DB_DRIVER);
            this.aqSchemaName = (String)env.get(DB_SCHEMA);
            this.aqServerPort = (String)env.get(DB_PORT);
            if (this.aqServerPort != null) {
                try {
                    this.aqServerPortNumber = Integer.parseInt(this.aqServerPort);
                }
                catch (NumberFormatException e) {
                    log.error((Object)"caught exception converting port", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        this.init(environment);
        Properties mockProperties = new Properties();
        mockProperties.setProperty("java.naming.factory.initial", MockContextFactory.class.getName());
        mockProperties.setProperty("java.naming.factory.url.pkgs", "org.mockejb.jndi");
        InitialContext context = new InitialContext(mockProperties);
        this.addAQDestinationContext(context);
        return context;
    }

    public void setAqDBDriver(String aqDBDriver) {
        this.aqDBDriver = aqDBDriver;
    }

    public void setAqSchemaName(String aqSchemaName) {
        this.aqSchemaName = aqSchemaName;
    }

    public void setAqServerDBInst(String aqServerDBInst) {
        this.aqServerDBInst = aqServerDBInst;
    }

    public void setAqServerName(String aqServerName) {
        this.aqServerName = aqServerName;
    }

    public void setAqServerPort(String aqServerPort) {
        this.aqServerPort = aqServerPort;
    }

    public void setAqServerPortNumber(int aqServerPortNumber) {
        this.aqServerPortNumber = aqServerPortNumber;
    }

    public void setDbpass(String dbpass) {
        this.dbpass = dbpass;
    }

    public void setDbuser(String dbuser) {
        this.dbuser = dbuser;
    }

    public void setAqConnectionUrl(String url) {
        this.aqConnectionUrl = url;
    }
}

