/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.sso;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.util.LifecycleSupport;
import org.jboss.cache.AbstractTreeCacheListener;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.config.Option;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.util.threadpool.ThreadPoolMBean;
import org.jboss.web.tomcat.service.sso.ClusteredSingleSignOn;
import org.jboss.web.tomcat.service.sso.SSOClusterManager;
import org.jboss.web.tomcat.service.sso.SingleSignOnEntry;
import org.jgroups.Address;
import org.jgroups.View;

public final class TreeCacheSSOClusterManager
extends AbstractTreeCacheListener
implements SSOClusterManager {
    private static final String CREDENTIALS = "credentials";
    private static final String SSO = "SSO";
    private static final String SESSIONS = "sessions";
    private static final String KEY = "key";
    public static final String DEFAULT_GLOBAL_CACHE_NAME = "jboss.cache:service=TomcatClusteringCache";
    public static final String DEFAULT_THREAD_POOL_NAME = "jboss.system:service=ThreadPool";
    private static final String[] GET_SIGNATURE = new String[]{Fqn.class.getName(), Object.class.getName(), Option.class.getName()};
    private static final String[] PUT_SIGNATURE = new String[]{Fqn.class.getName(), Object.class.getName(), Object.class.getName(), Option.class.getName()};
    private static final String[] REMOVE_SIGNATURE = new String[]{Fqn.class.getName(), Option.class.getName()};
    private static final Option GRAVITATE_OPTION = new Option();
    private static final Option LOCAL_OPTION = new Option();
    private ThreadLocal beingLocallyAdded = new ThreadLocal();
    private ThreadLocal beingLocallyRemoved = new ThreadLocal();
    private ThreadLocal beingRemotelyRemoved = new ThreadLocal();
    private ObjectName cacheObjectName = null;
    private String threadPoolName = "jboss.system:service=ThreadPool";
    private ThreadPool threadPool;
    private String cacheName = null;
    private TransactionManager tm = null;
    private LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private Logger log = Logger.getLogger((String)this.getClass().getName());
    private boolean registeredAsListener = false;
    private MBeanServer server = null;
    private ClusteredSingleSignOn ssoValve = null;
    private boolean started = false;
    private boolean treeCacheAvailable = false;
    private boolean missingCacheErrorLogged = false;
    private Serializable localAddress = null;
    private Set currentView;
    private Object cleanupMutex = new Object();
    private boolean checkForInvalidAddresses = false;

    public TreeCacheSSOClusterManager() {
        this.server = MBeanServerLocator.locateJBoss();
        if (this.server == null) {
            this.server = MBeanServerLocator.locate();
        }
    }

    public TreeCacheSSOClusterManager(MBeanServer server) {
        this.server = server;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String objectName) throws Exception {
        if (objectName == null) {
            this.setCacheObjectName(null);
        } else if (!objectName.equals(this.cacheName)) {
            this.setCacheObjectName(new ObjectName(objectName));
        }
    }

    public ObjectName getCacheObjectName() {
        return this.cacheObjectName;
    }

    public void setCacheObjectName(ObjectName objectName) throws Exception {
        if (objectName != null && objectName.equals(this.cacheObjectName) || this.cacheObjectName != null && this.cacheObjectName.equals(objectName) || objectName == null && this.cacheObjectName == null) {
            return;
        }
        this.removeAsTreeCacheListener();
        this.tm = null;
        this.cacheObjectName = objectName;
        String string = this.cacheName = objectName == null ? null : objectName.getCanonicalName();
        if (!this.isTreeCacheAvailable(true)) {
            if (this.started) {
                this.logMissingCacheError();
            } else {
                this.log.info((Object)("Cannot find TreeCache using " + this.cacheName + " -- tree" + "CacheName must be set to point to a running TreeCache " + "before ClusteredSingleSignOn can handle requests"));
            }
        }
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        if (this.started) {
            this.log.info((Object)"Call to setThreadPoolName() ignored; already started");
        } else {
            this.threadPoolName = threadPoolName;
        }
    }

    public boolean isUsingThreadPool() {
        return this.threadPool != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(String ssoId, Session session) {
        if (ssoId == null || session == null) {
            return;
        }
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("addSession(): adding Session " + session.getId() + " to cached session set for SSO " + ssoId));
        }
        Fqn fqn = this.getSessionsFqn(ssoId);
        boolean doTx = false;
        try {
            try {
                if (this.tm == null) {
                    this.configureFromCache();
                }
                if (this.tm.getTransaction() == null) {
                    doTx = true;
                }
                if (doTx) {
                    this.tm.begin();
                }
                Set sessions = this.getSessionSet(fqn, true, false);
                sessions.add(new SessionAddress(session.getId(), this.localAddress));
                if (this.checkForInvalidAddresses) {
                    TreeCacheSSOClusterManager.cleanDeadMembers(sessions, new HashSet(this.currentView));
                }
                this.putInTreeCache(fqn, sessions, false);
            }
            catch (Exception e) {
                try {
                    if (doTx) {
                        this.tm.setRollbackOnly();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                String sessId = session == null ? "NULL" : session.getId();
                this.log.error((Object)("caught exception adding session " + sessId + " to SSO id " + ssoId), (Throwable)e);
                Object var8_8 = null;
                if (doTx) {
                    this.endTransaction();
                }
            }
            Object var8_7 = null;
            if (doTx) {
                this.endTransaction();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (doTx) {
                this.endTransaction();
            }
            throw throwable;
        }
    }

    public ClusteredSingleSignOn getSingleSignOnValve() {
        return this.ssoValve;
    }

    public void setSingleSignOnValve(ClusteredSingleSignOn valve) {
        this.ssoValve = valve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(String ssoId) {
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (ssoId.equals(this.beingLocallyRemoved.get())) {
            return;
        }
        this.beingLocallyRemoved.set(ssoId);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Registering logout of SSO " + ssoId + " in clustered cache"));
        }
        Fqn fqn = this.getSingleSignOnFqn(ssoId);
        try {
            try {
                this.removeFromTreeCache(fqn);
            }
            catch (Exception e) {
                this.log.error((Object)("Exception attempting to remove node " + fqn.toString() + " from TreeCache"), (Throwable)e);
                Object var5_4 = null;
                this.beingLocallyRemoved.set(null);
            }
            Object var5_3 = null;
            this.beingLocallyRemoved.set(null);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.beingLocallyRemoved.set(null);
            throw throwable;
        }
    }

    public SingleSignOnEntry lookup(String ssoId) {
        if (!this.checkTreeCacheAvailable()) {
            return null;
        }
        SingleSignOnEntry entry = null;
        Fqn fqn = this.getCredentialsFqn(ssoId);
        try {
            SSOCredentials data = (SSOCredentials)this.getFromTreeCache(fqn, false);
            if (data != null) {
                entry = new SingleSignOnEntry(null, data.getAuthType(), data.getUsername(), data.getPassword());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("caught exception looking up SSOCredentials for SSO id " + ssoId), (Throwable)e);
        }
        return entry;
    }

    public void register(String ssoId, String authType, String username, String password) {
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Registering SSO " + ssoId + " in clustered cache"));
        }
        this.storeSSOData(ssoId, authType, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String ssoId, Session session) {
        if (ssoId == null || session == null) {
            return;
        }
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (ssoId.equals(this.beingRemotelyRemoved.get())) {
            return;
        }
        Fqn fqn = this.getSessionsFqn(ssoId);
        boolean doTx = false;
        try {
            block18: {
                try {
                    Set sessions;
                    if (this.tm == null) {
                        this.configureFromCache();
                    }
                    if (this.tm.getTransaction() == null) {
                        doTx = true;
                    }
                    if (doTx) {
                        this.tm.begin();
                    }
                    if ((sessions = this.getSessionSet(fqn, false, false)) == null) break block18;
                    sessions.remove(new SessionAddress(session.getId(), this.localAddress));
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("removed session " + session.getId() + " from cached session set for SSO " + ssoId + " -- " + sessions.size() + " sessions remain"));
                    }
                    if (this.checkForInvalidAddresses) {
                        TreeCacheSSOClusterManager.cleanDeadMembers(sessions, new HashSet(this.currentView));
                    }
                    this.putInTreeCache(fqn, sessions, false);
                }
                catch (Exception e) {
                    try {
                        if (doTx) {
                            this.tm.setRollbackOnly();
                        }
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                    String sessId = session == null ? "NULL" : session.getId();
                    this.log.error((Object)("caught exception removing session " + sessId + " from SSO id " + ssoId), (Throwable)e);
                    Object var8_8 = null;
                    if (doTx) {
                        this.endTransaction();
                    }
                }
            }
            Object var8_7 = null;
            if (doTx) {
                this.endTransaction();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (doTx) {
                this.endTransaction();
            }
            throw throwable;
        }
    }

    public void updateCredentials(String ssoId, String authType, String username, String password) {
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Updating credentials for SSO " + ssoId + " in clustered cache"));
        }
        this.storeSSOData(ssoId, authType, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeRemoved(Fqn fqn) {
        String ssoId = this.getIdFromFqn(fqn);
        if (ssoId == null) {
            return;
        }
        if (ssoId.equals(this.beingLocallyRemoved.get())) {
            return;
        }
        this.beingRemotelyRemoved.set(ssoId);
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("received a node removed message for SSO " + ssoId));
            }
            this.ssoValve.deregister(ssoId);
            Object var4_3 = null;
            this.beingRemotelyRemoved.set(null);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.beingRemotelyRemoved.set(null);
            throw throwable;
        }
    }

    public void nodeModified(Fqn fqn) {
        String type = this.getTypeFromFqn(fqn);
        if (CREDENTIALS.equals(type)) {
            this.handleCredentialUpdate(fqn);
        } else if (SESSIONS.equals(type)) {
            this.handleSessionSetChange(fqn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCredentialUpdate(Fqn fqn) {
        block9: {
            String ssoId = this.getIdFromFqn(fqn);
            if (ssoId.equals(this.beingLocallyAdded.get())) {
                return;
            }
            SingleSignOnEntry sso = this.ssoValve.localLookup(ssoId);
            if (sso == null || sso.getCanReauthenticate()) {
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("received a credentials modified message for SSO " + ssoId));
            }
            try {
                SSOCredentials data = (SSOCredentials)this.getFromTreeCache(fqn, false);
                if (data == null) break block9;
                String authType = data.getAuthType();
                String username = data.getUsername();
                String password = data.getPassword();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("CredentialUpdater: Updating credentials for SSO " + sso));
                }
                SingleSignOnEntry singleSignOnEntry = sso;
                synchronized (singleSignOnEntry) {
                    Principal p = sso.getPrincipal();
                    sso.updateCredentials(p, authType, username, password);
                }
            }
            catch (Exception e) {
                this.log.error((Object)("failed to update credentials for SSO " + ssoId), (Throwable)e);
            }
        }
    }

    private void handleSessionSetChange(Fqn fqn) {
        String ssoId = this.getIdFromFqn(fqn);
        try {
            Set sessions = (Set)this.getFromTreeCache(fqn, false);
            if (sessions != null) {
                if (sessions.size() == 0) {
                    this.ssoValve.notifySSOEmpty(ssoId);
                } else {
                    this.ssoValve.notifySSONotEmpty(ssoId);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("failed in check for empty SSO " + ssoId), (Throwable)e);
        }
    }

    public synchronized void viewChange(View new_view) {
        Set oldMembers = this.currentView;
        this.currentView = new HashSet(new_view.getMembers());
        if (oldMembers == null) {
            return;
        }
        if (this.localAddress == null || !this.currentView.contains((Address)this.localAddress)) {
            return;
        }
        oldMembers.removeAll(this.currentView);
        if (oldMembers.size() > 0) {
            this.checkForInvalidAddresses = true;
            DeadMemberCleaner cleaner = new DeadMemberCleaner();
            if (this.threadPool != null) {
                this.threadPool.run((Runnable)cleaner);
            } else {
                Thread t = new Thread((Runnable)cleaner, "ClusteredSSOCleaner");
                t.setDaemon(true);
                t.start();
            }
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException("TreeCacheSSOClusterManager already Started");
        }
        try {
            if (this.isTreeCacheAvailable(true)) {
                this.integrateWithCache();
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Caught exception looking up TransactionManager from TreeCache", (Throwable)e);
        }
        this.initThreadPool();
        this.started = true;
        this.lifecycle.fireLifecycleEvent("start", null);
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("TreeCacheSSOClusterManager not Started");
        }
        this.started = false;
        this.lifecycle.fireLifecycleEvent("stop", null);
    }

    private Object getFromTreeCache(Fqn fqn, boolean localOnly) throws Exception {
        Object[] args = new Object[]{fqn, KEY, localOnly ? LOCAL_OPTION : GRAVITATE_OPTION};
        return this.server.invoke(this.getCacheObjectName(), "get", args, GET_SIGNATURE);
    }

    private Set getSSOIds() throws Exception {
        Fqn ssoRoot = new Fqn(new Object[]{SSO});
        Set ssoIds = (Set)this.server.invoke(this.getCacheObjectName(), "getChildrenNames", new Object[]{ssoRoot}, new String[]{Fqn.class.getName()});
        return ssoIds == null ? new HashSet() : ssoIds;
    }

    private Fqn getCredentialsFqn(String ssoid) {
        Object[] objs = new Object[]{SSO, ssoid, CREDENTIALS};
        return new Fqn(objs);
    }

    private Fqn getSessionsFqn(String ssoid) {
        Object[] objs = new Object[]{SSO, ssoid, SESSIONS};
        return new Fqn(objs);
    }

    private Fqn getSingleSignOnFqn(String ssoid) {
        Object[] objs = new Object[]{SSO, ssoid};
        return new Fqn(objs);
    }

    private String getIdFromFqn(Fqn fqn) {
        String id = null;
        if (fqn.size() > 1 && SSO.equals(fqn.get(0))) {
            id = (String)fqn.get(1);
        }
        return id;
    }

    private Set getSessionSet(Fqn fqn, boolean create, boolean localOnly) throws Exception {
        HashSet sessions = (HashSet)this.getFromTreeCache(fqn, localOnly);
        if (create && sessions == null) {
            sessions = new HashSet();
        }
        return sessions;
    }

    private String getTypeFromFqn(Fqn fqn) {
        String type = null;
        if (fqn.size() > 2 && SSO.equals(fqn.get(0))) {
            type = (String)fqn.get(2);
        }
        return type;
    }

    private void configureFromCache() throws Exception {
        this.tm = (TransactionManager)this.server.getAttribute(this.getCacheObjectName(), "TransactionManager");
        if (this.tm == null) {
            throw new IllegalStateException("TreeCache does not have a transaction manager; please configure a valid TransactionManagerLookupClass");
        }
        Object address = this.server.getAttribute(this.cacheObjectName, "LocalAddress");
        this.localAddress = address instanceof Serializable ? (Serializable)address : address.toString();
        Vector members = (Vector)this.server.getAttribute(this.getCacheObjectName(), "Members");
        if (members != null) {
            this.currentView = new HashSet(members);
        }
    }

    private void endTransaction() {
        try {
            if (this.tm.getTransaction().getStatus() != 1) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new NestedRuntimeException("TreeCacheSSOClusterManager.endTransaction(): ", (Throwable)e);
        }
    }

    private synchronized boolean isTreeCacheAvailable(boolean forceCheck) {
        if (forceCheck || !this.treeCacheAvailable) {
            boolean available;
            boolean bl = available = this.cacheObjectName != null;
            if (available) {
                Set<ObjectInstance> s = this.server.queryMBeans(this.cacheObjectName, null);
                boolean bl2 = available = s.size() > 0;
                if (available) {
                    try {
                        if (this.started) {
                            this.integrateWithCache();
                        }
                        this.setMissingCacheErrorLogged(false);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Caught exception configuring from cache " + this.cacheObjectName), (Throwable)e);
                        available = false;
                    }
                }
            }
            this.treeCacheAvailable = available;
        }
        return this.treeCacheAvailable;
    }

    private boolean checkTreeCacheAvailable() {
        boolean avail = this.isTreeCacheAvailable(false);
        if (!avail) {
            this.logMissingCacheError();
        }
        return avail;
    }

    private void putInTreeCache(Fqn fqn, Object data, boolean localOnly) throws Exception {
        Object[] args = new Object[]{fqn, KEY, data, localOnly ? LOCAL_OPTION : GRAVITATE_OPTION};
        this.server.invoke(this.getCacheObjectName(), "put", args, PUT_SIGNATURE);
    }

    private void integrateWithCache() throws Exception {
        this.configureFromCache();
        this.activateCacheRegion();
        this.registerAsTreeCacheListener();
        this.log.debug((Object)("Successfully integrated with cache service " + this.cacheObjectName));
    }

    private void activateCacheRegion() throws Exception {
        block5: {
            try {
                Boolean useMarshalling;
                Boolean inactive = (Boolean)this.server.getAttribute(this.cacheObjectName, "InactiveOnStartup");
                if (!inactive.booleanValue() || !(useMarshalling = (Boolean)this.server.getAttribute(this.cacheObjectName, "UseMarshalling")).booleanValue()) break block5;
                try {
                    this.server.invoke(this.cacheObjectName, "activateRegion", new Object[]{"/SSO"}, new String[]{"java.lang.String"});
                }
                catch (MBeanException e) {
                    Exception cause = e.getTargetException();
                    if (cause != null && "org.jboss.cache.RegionNotEmptyException".equals(cause.getClass().getName())) {
                        this.log.debug((Object)"SSO region already active", (Throwable)cause);
                        break block5;
                    }
                    throw e;
                }
            }
            catch (AttributeNotFoundException ignore) {
                this.log.debug((Object)"Attribute InactiveOnStartup not available; must be using JBossCache 1.2.3 or earlier");
            }
        }
    }

    private void registerAsTreeCacheListener() throws Exception {
        this.server.invoke(this.cacheObjectName, "addTreeCacheListener", new Object[]{this}, new String[]{TreeCacheListener.class.getName()});
        this.registeredAsListener = true;
    }

    private void removeAsTreeCacheListener() throws Exception {
        if (this.registeredAsListener && this.cacheObjectName != null) {
            this.server.invoke(this.cacheObjectName, "removeTreeCacheListener", new Object[]{this}, new String[]{TreeCacheListener.class.getName()});
        }
    }

    private void removeFromTreeCache(Fqn fqn) throws Exception {
        this.server.invoke(this.getCacheObjectName(), "remove", new Object[]{fqn, GRAVITATE_OPTION}, REMOVE_SIGNATURE);
    }

    private void initThreadPool() {
        if (this.threadPoolName != null) {
            try {
                ObjectName on = new ObjectName(this.threadPoolName);
                ThreadPoolMBean mbean = (ThreadPoolMBean)MBeanProxyExt.create(ThreadPoolMBean.class, (ObjectName)on, (MBeanServer)this.server);
                this.threadPool = mbean.getInstance();
                this.log.debug((Object)("Using ThreadPool at " + this.threadPoolName + " to clean dead members"));
            }
            catch (Exception e) {
                this.log.info((Object)("Unable to access ThreadPool at " + this.threadPoolName + " -- will use individual threads for cleanup work"));
                this.log.debug((Object)("Failure to access ThreadPool due to: " + e));
            }
        } else {
            this.log.debug((Object)"No ThreadPool configured -- will use individual threads for cleanup work");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSSOData(String ssoId, String authType, String username, String password) {
        SSOCredentials data = new SSOCredentials(authType, username, password);
        this.beingLocallyAdded.set(ssoId);
        try {
            try {
                this.putInTreeCache(this.getCredentialsFqn(ssoId), data, false);
            }
            catch (Exception e) {
                this.log.error((Object)("Exception attempting to add TreeCache nodes for SSO " + ssoId), (Throwable)e);
                Object var8_7 = null;
                this.beingLocallyAdded.set(null);
            }
            Object var8_6 = null;
            this.beingLocallyAdded.set(null);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.beingLocallyAdded.set(null);
            throw throwable;
        }
    }

    private boolean isMissingCacheErrorLogged() {
        return this.missingCacheErrorLogged;
    }

    private void setMissingCacheErrorLogged(boolean missingCacheErrorLogged) {
        this.missingCacheErrorLogged = missingCacheErrorLogged;
    }

    private void logMissingCacheError() {
        StringBuffer msg = new StringBuffer("Cannot find TreeCache using ");
        msg.append(this.getCacheName());
        msg.append(" -- TreeCache must be started before ClusteredSingleSignOn ");
        msg.append("can handle requests");
        if (this.isMissingCacheErrorLogged()) {
            this.log.warn((Object)msg);
        } else {
            this.log.error((Object)msg);
            this.setMissingCacheErrorLogged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cleanDeadMembers(Set sessionSet, Set currentMembers) {
        boolean changed = false;
        Set set = sessionSet;
        synchronized (set) {
            Iterator iter = sessionSet.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof SessionAddress) || currentMembers.contains(((SessionAddress)obj).address)) continue;
                iter.remove();
                changed = true;
            }
        }
        return changed;
    }

    static {
        GRAVITATE_OPTION.setForceDataGravitation(true);
        LOCAL_OPTION.setCacheModeLocal(true);
    }

    private class DeadMemberCleaner
    implements Runnable {
        private DeadMemberCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = TreeCacheSSOClusterManager.this.cleanupMutex;
            synchronized (object) {
                try {
                    if (TreeCacheSSOClusterManager.this.tm == null) {
                        TreeCacheSSOClusterManager.this.configureFromCache();
                    }
                    Set ids = TreeCacheSSOClusterManager.this.getSSOIds();
                    HashSet members = new HashSet(TreeCacheSSOClusterManager.this.currentView);
                    Iterator iter = ids.iterator();
                    while (iter.hasNext()) {
                        this.cleanDeadMembersFromSSO((String)iter.next(), members);
                    }
                    TreeCacheSSOClusterManager.this.checkForInvalidAddresses = false;
                }
                catch (Exception e) {
                    TreeCacheSSOClusterManager.this.log.error((Object)"Caught exception cleaning sessions from dead cluster members from SSOs ", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void cleanDeadMembersFromSSO(String ssoId, Set currentMembers) {
            Fqn fqn = TreeCacheSSOClusterManager.this.getSessionsFqn(ssoId);
            boolean doTx = false;
            try {
                block9: {
                    try {
                        boolean changed;
                        Set sessions;
                        if (TreeCacheSSOClusterManager.this.tm.getTransaction() == null) {
                            doTx = true;
                        }
                        if (doTx) {
                            TreeCacheSSOClusterManager.this.tm.begin();
                        }
                        if ((sessions = TreeCacheSSOClusterManager.this.getSessionSet(fqn, false, true)) == null || sessions.size() <= 0 || !(changed = TreeCacheSSOClusterManager.cleanDeadMembers(sessions, currentMembers)) || sessions.size() != 0) break block9;
                        TreeCacheSSOClusterManager.this.ssoValve.notifySSOEmpty(ssoId);
                    }
                    catch (Exception e) {
                        try {
                            if (doTx) {
                                TreeCacheSSOClusterManager.this.tm.setRollbackOnly();
                            }
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        TreeCacheSSOClusterManager.this.log.error((Object)("caught exception cleaning dead members from SSO " + ssoId), (Throwable)e);
                        Object var8_10 = null;
                        if (!doTx) return;
                        TreeCacheSSOClusterManager.this.endTransaction();
                        return;
                    }
                }
                Object var8_9 = null;
                if (!doTx) return;
                TreeCacheSSOClusterManager.this.endTransaction();
                return;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (!doTx) throw throwable;
                TreeCacheSSOClusterManager.this.endTransaction();
                throw throwable;
            }
        }
    }

    static class SessionAddress
    implements Serializable {
        private static final long serialVersionUID = -3702932999380140004L;
        Serializable address;
        String sessionId;

        SessionAddress(String sessionId, Serializable address) {
            this.sessionId = sessionId;
            this.address = address;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SessionAddress)) {
                return false;
            }
            SessionAddress other = (SessionAddress)obj;
            return this.sessionId.equals(other.sessionId) && this.address.equals(other.address);
        }

        public int hashCode() {
            int total = 817 + this.sessionId.hashCode();
            return total * 43 + this.address.hashCode();
        }
    }

    public static class SSOCredentials
    implements Serializable {
        private static final long serialVersionUID = 5704877226920571663L;
        private String authType = null;
        private String password = null;
        private String username = null;

        private SSOCredentials(String authType, String username, String password) {
            this.authType = authType;
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getAuthType() {
            return this.authType;
        }

        private String getPassword() {
            return this.password;
        }
    }
}

