/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.commons.ssl.SSL;
import org.apache.commons.ssl.SSLWrapperFactory;
import org.apache.commons.ssl.TrustChain;

public class SSLServer
extends SSLServerSocketFactory {
    protected final SSL ssl;

    public SSLServer() throws GeneralSecurityException, IOException {
        block3: {
            String userHome;
            String path;
            File f;
            this.ssl = new SSL();
            this.setCheckHostname(false);
            Properties props = System.getProperties();
            boolean ksSet = props.containsKey("javax.net.ssl.keyStore");
            boolean pwdSet = props.containsKey("javax.net.ssl.keyStorePassword");
            String pwd = props.getProperty("javax.net.ssl.keyStorePassword");
            String string = pwd = pwdSet ? pwd : "changeit";
            if (!ksSet && (f = new File(path = (userHome = System.getProperty("user.home")) + "/.keystore")).exists()) {
                try {
                    KeyMaterial km = new KeyMaterial(path, pwd.toCharArray());
                    this.setKeyMaterial(km);
                }
                catch (Exception e) {
                    if (!pwdSet) break block3;
                    System.out.println("commons-ssl automatic loading of [" + path + "] failed. ");
                    System.out.println(e);
                }
            }
        }
    }

    public void addTrustMaterial(TrustChain trustChain) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.ssl.addTrustMaterial(trustChain);
    }

    public void setTrustMaterial(TrustChain trustChain) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.ssl.setTrustMaterial(trustChain);
    }

    public void setKeyMaterial(KeyMaterial keyMaterial) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.ssl.setKeyMaterial(keyMaterial);
    }

    public String[] getEnabledCiphers() {
        return this.ssl.getEnabledCiphers();
    }

    public void setEnabledCiphers(String[] ciphers) throws IllegalArgumentException {
        this.ssl.setEnabledCiphers(ciphers);
    }

    public String[] getEnabledProtocols() {
        return this.ssl.getEnabledProtocols();
    }

    public void setEnabledProtocols(String[] protocols) {
        this.ssl.setEnabledProtocols(protocols);
    }

    public void setCheckExpiry(boolean checkExpiry) {
        this.ssl.setCheckExpiry(checkExpiry);
    }

    public boolean getCheckExpiry() {
        return this.ssl.getCheckExpiry();
    }

    public void setCheckHostname(boolean checkHostname) {
        this.ssl.setCheckHostname(checkHostname);
    }

    public boolean getCheckHostname() {
        return this.ssl.getCheckHostname();
    }

    public X509Certificate[] getAssociatedCertificateChain() {
        return this.ssl.getAssociatedCertificateChain();
    }

    public void setCheckCRL(boolean checkCRL) {
        this.ssl.setCheckCRL(checkCRL);
    }

    public boolean getCheckCRL() {
        return this.ssl.getCheckCRL();
    }

    public void setSoTimeout(int soTimeout) {
        this.ssl.setSoTimeout(soTimeout);
    }

    public void setUseClientMode(boolean useClientMode) {
        this.ssl.setUseClientMode(useClientMode);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.ssl.setConnectTimeout(connectTimeout);
    }

    public void setDefaultProtocol(String protocol) {
        this.ssl.setDefaultProtocol(protocol);
    }

    public TrustChain getTrustChain() {
        return this.ssl.getTrustChain();
    }

    public String[] getDefaultCipherSuites() {
        return this.ssl.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.ssl.getSupportedCipherSuites();
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.ssl.setWantClientAuth(wantClientAuth);
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.ssl.setNeedClientAuth(needClientAuth);
    }

    public boolean getWantClientAuth() {
        return this.ssl.getWantClientAuth();
    }

    public boolean getNeedClientAuth() {
        return this.ssl.getNeedClientAuth();
    }

    public SSLWrapperFactory getSSLWrapperFactory() {
        return this.ssl.getSSLWrapperFactory();
    }

    public void setSSLWrapperFactory(SSLWrapperFactory wf) {
        this.ssl.setSSLWrapperFactory(wf);
    }

    public ServerSocket createServerSocket() throws IOException {
        SSLServerSocket ss = JavaImpl.createServerSocket(this.ssl);
        return this.ssl.getSSLWrapperFactory().wrap(ss, this);
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return this.createServerSocket(port, 50);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.createServerSocket(port, backlog, null);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress localHost) throws IOException {
        SSLServerSocketFactory f = this.ssl.getSSLServerSocketFactory();
        ServerSocket ss = f.createServerSocket(port, backlog, localHost);
        SSLServerSocket s = (SSLServerSocket)ss;
        this.ssl.doPreConnectServerSocketStuff(s);
        return this.ssl.getSSLWrapperFactory().wrap(s, this);
    }

    public X509Certificate[] getCurrentClientChain() {
        return this.ssl.getCurrentClientChain();
    }
}

