/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.commons.ssl.Certificates;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.KeyStoreBuilder;
import org.apache.commons.ssl.TrustMaterial;
import org.apache.commons.ssl.Util;

public class KeyMaterial
extends TrustMaterial {
    private Object keyManagerFactory;
    private String alias;
    private X509Certificate[] associatedChain;

    public KeyMaterial(InputStream jks, char[] password) throws GeneralSecurityException, IOException {
        this(Util.streamToBytes(jks), password);
    }

    public KeyMaterial(InputStream jks, InputStream key, char[] password) throws GeneralSecurityException, IOException {
        this(Util.streamToBytes(jks), Util.streamToBytes(key), password);
    }

    public KeyMaterial(String pathToJksFile, char[] password) throws GeneralSecurityException, IOException {
        this(new File(pathToJksFile), password);
    }

    public KeyMaterial(String pathToCerts, String pathToKey, char[] password) throws GeneralSecurityException, IOException {
        this(new File(pathToCerts), new File(pathToKey), password);
    }

    public KeyMaterial(File jksFile, char[] password) throws GeneralSecurityException, IOException {
        this(new FileInputStream(jksFile), password);
    }

    public KeyMaterial(File certsFile, File keyFile, char[] password) throws GeneralSecurityException, IOException {
        this(new FileInputStream(certsFile), new FileInputStream(keyFile), password);
    }

    public KeyMaterial(URL urlToJKS, char[] password) throws GeneralSecurityException, IOException {
        this(urlToJKS.openStream(), password);
    }

    public KeyMaterial(URL urlToCerts, URL urlToKey, char[] password) throws GeneralSecurityException, IOException {
        this(urlToCerts.openStream(), urlToKey.openStream(), password);
    }

    public KeyMaterial(byte[] jks, char[] password) throws GeneralSecurityException, IOException {
        this(jks, null, password);
    }

    public KeyMaterial(byte[] jksOrCerts, byte[] key, char[] password) throws GeneralSecurityException, IOException {
        super(KeyStoreBuilder.build(jksOrCerts, key, password), 0);
        Certificate[] chain;
        KeyStore ks = this.getKeyStore();
        Enumeration<String> en = ks.aliases();
        int privateKeyCount = 0;
        while (en.hasMoreElements()) {
            String alias = en.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            if (++privateKeyCount > 1) {
                throw new KeyStoreException("commons-ssl KeyMaterial only supports keystores with a single private key.");
            }
            this.alias = alias;
        }
        if (this.alias != null && (chain = ks.getCertificateChain(this.alias)) != null) {
            X509Certificate[] x509Chain = new X509Certificate[chain.length];
            for (int i = 0; i < chain.length; ++i) {
                x509Chain[i] = (X509Certificate)chain[i];
            }
            this.associatedChain = x509Chain;
        }
        this.keyManagerFactory = JavaImpl.newKeyManagerFactory(ks, password);
    }

    public Object[] getKeyManagers() {
        return JavaImpl.getKeyManagers(this.keyManagerFactory);
    }

    public X509Certificate[] getAssociatedCertificateChain() {
        return this.associatedChain;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage:  java org.apache.commons.ssl.KeyMaterial [client-cert] [password]");
            System.exit(1);
        }
        String keypath = args[0];
        char[] password = args[1].toCharArray();
        KeyMaterial km = new KeyMaterial(keypath, password);
        X509Certificate[] certs = km.getAssociatedCertificateChain();
        for (int i = 0; i < certs.length; ++i) {
            System.out.print(Certificates.toString(certs[i]));
            System.out.print(Certificates.toPEMString(certs[i]));
        }
    }
}

