/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class Update
extends SvnCommand {
    private File file = null;
    private File dir = null;
    private Vector filesets = new Vector();
    private SVNRevision revision = SVNRevision.HEAD;
    private boolean recurse = true;

    public void execute() throws SvnAntException {
        if (this.file != null) {
            try {
                this.svnClient.update(this.file, this.revision, false);
            }
            catch (SVNClientException sVNClientException) {
                throw new SvnAntException("Cannot update file " + this.file.getAbsolutePath(), sVNClientException);
            }
        }
        if (this.dir != null) {
            try {
                this.svnClient.update(this.dir, this.revision, this.recurse);
            }
            catch (SVNClientException sVNClientException) {
                throw new SvnAntException("Cannot update dir " + this.dir.getAbsolutePath(), sVNClientException);
            }
        }
        if (this.filesets.size() > 0) {
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fileSet = (FileSet)this.filesets.elementAt(i);
                this.updateFileSet(fileSet);
            }
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.file == null && this.dir == null && this.filesets.size() == 0) {
            throw new SvnAntValidationException("file, url or fileset must be set");
        }
        if (this.revision == null) {
            throw SvnAntValidationException.createInvalidRevisionException();
        }
    }

    private void updateFileSet(FileSet fileSet) throws SvnAntException {
        File file;
        int n;
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file2 = fileSet.getDir(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        String[] stringArray2 = directoryScanner.getIncludedDirectories();
        for (n = 0; n < stringArray2.length; ++n) {
            file = new File(file2, stringArray2[n]);
            try {
                this.svnClient.update(file, this.revision, false);
                continue;
            }
            catch (SVNClientException sVNClientException) {
                this.logError("Cannot update directory " + file.getAbsolutePath());
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            file = new File(file2, stringArray[n]);
            try {
                this.svnClient.update(file, this.revision, false);
                continue;
            }
            catch (SVNClientException sVNClientException) {
                this.logError("Cannot update file " + file.getAbsolutePath());
            }
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setRevision(String string) {
        this.revision = this.getRevisionFrom(string);
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void add(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }
}

