/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.util;

import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIUtil {
    private static Log logger = LogFactory.getLog(JNDIUtil.class);

    private JNDIUtil() {
    }

    public static Context getNamingContext(Properties jndiProperties) throws NamingException {
        InitialContext context;
        try {
            context = jndiProperties.isEmpty() ? new InitialContext() : new InitialContext(jndiProperties);
        }
        catch (NamingException e) {
            logger.error((Object)("NamingException while try to create initialContext. jndiProperties are " + jndiProperties), (Throwable)e);
            throw (NamingException)new NamingException("Failed to load InitialContext: " + jndiProperties).initCause(e);
        }
        if (context == null) {
            throw new NamingException("Failed to create JNDI context.  Check that 'java.naming.provider.url', 'java.naming.factory.initial', 'java.naming.factory.url.pkgs' are correctly configured in the supplied JNDI properties.");
        }
        return context;
    }

    public static Object lookup(String objectName, Properties jndiProperties) throws NamingException {
        Object object = null;
        Context context = JNDIUtil.getNamingContext(jndiProperties);
        try {
            object = context.lookup(objectName);
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException ne) {
                logger.error((Object)"Failed to close Naming Context.", (Throwable)ne);
            }
        }
        return object;
    }

    public static Object lookup(String objectName, Properties jndiProperties, ClassLoader[] classLoaders) throws NamingException {
        ClassLoader tcClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader[] classLoaderArray = classLoaders;
            int n = classLoaders.length;
            int n2 = 0;
            while (n2 < n) {
                ClassLoader classLoader = classLoaderArray[n2];
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    Object object = JNDIUtil.lookup(objectName, jndiProperties);
                    return object;
                }
                catch (NamingException e) {
                    logger.debug((Object)("NamingException while trying to lookup '" + objectName + "' using JNDI Properties '" + jndiProperties + "', classloader used '" + classLoader + "'"), (Throwable)e);
                    ++n2;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcClassLoader);
        }
        throw new NamingException("JNDI lookup of Object [" + objectName + "] failed.");
    }

    public static Properties getDefaultProperties() {
        Properties defaultProperties = new Properties();
        try {
            InitialContext context = new InitialContext();
            defaultProperties.putAll((Map<?, ?>)context.getEnvironment());
        }
        catch (Exception e) {
            logger.debug((Object)"Unexpected exception when trying to retrieve default naming context.", (Throwable)e);
        }
        return defaultProperties;
    }
}

