/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.payload;

import com.thoughtworks.xstream.XStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.milyn.assertion.AssertArgument;
import org.milyn.payload.FilterResult;

public class JavaResult
extends FilterResult {
    private Map<String, Object> resultMap;

    public JavaResult() {
        this(false);
    }

    public JavaResult(boolean preserveOrder) {
        this.resultMap = preserveOrder ? new LinkedHashMap<String, Object>() : new HashMap<String, Object>();
    }

    public JavaResult(Map<String, Object> resultMap) {
        AssertArgument.isNotNull(resultMap, "resultMap");
        this.resultMap = resultMap;
    }

    public Object getBean(String name) {
        return this.resultMap.get(name);
    }

    public Map<String, Object> getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(Map<String, Object> resultMap) {
        this.resultMap = resultMap;
    }

    public String toString() {
        StringWriter stringBuilder = new StringWriter();
        XStream xstream = new XStream();
        if (this.resultMap != null && !this.resultMap.isEmpty()) {
            Set<Map.Entry<String, Object>> entries = this.resultMap.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                stringBuilder.write(String.valueOf(entry.getKey()) + ":\n");
                stringBuilder.write(String.valueOf(xstream.toXML(entry.getValue())) + "\n\n");
            }
        }
        return stringBuilder.toString();
    }
}

