/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import org.milyn.delivery.sax.SAXElement;
import org.xml.sax.Attributes;

public abstract class SAXUtil {
    public static String getAttribute(String attributeName, Attributes attributes) {
        return SAXUtil.getAttribute(attributeName, attributes, "");
    }

    public static String getAttribute(String attributeName, Attributes attributes, String defaultVal) {
        return SAXUtil.getAttribute("", attributeName, attributes, defaultVal);
    }

    public static String getAttribute(String attributeNamespace, String attributeName, Attributes attributes, String defaultVal) {
        int attribCount = attributes.getLength();
        int i = 0;
        while (i < attribCount) {
            String attribName = attributes.getLocalName(i);
            if (attribName.equalsIgnoreCase(attributeName) && attributes.getURI(i).equals(attributeNamespace)) {
                return attributes.getValue(i);
            }
            ++i;
        }
        return defaultVal;
    }

    public static String getXPath(SAXElement element) {
        StringBuilder builder = new StringBuilder();
        SAXUtil.addXPathElement(element, builder);
        return builder.toString();
    }

    private static void addXPathElement(SAXElement element, StringBuilder builder) {
        if (builder.length() > 0) {
            builder.insert(0, "/");
            builder.insert(0, element.getName().getLocalPart());
        } else {
            builder.append(element.getName().getLocalPart());
        }
        SAXElement parent = element.getParent();
        if (parent != null) {
            SAXUtil.addXPathElement(parent, builder);
        }
    }

    public static int getDepth(SAXElement element) {
        int depth = 0;
        SAXElement parent = element.getParent();
        while (parent != null) {
            ++depth;
            parent = parent.getParent();
        }
        return depth;
    }
}

