/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.ContentHandlerConfigMap;
import org.milyn.delivery.ordering.Sorter;

public class ContentHandlerConfigMapTable<T extends ContentHandler> {
    private Map<String, List<ContentHandlerConfigMap<T>>> table = new LinkedHashMap<String, List<ContentHandlerConfigMap<T>>>();
    private int count = 0;
    private int userConfiguredCount = 0;

    public void addMapping(String elementName, SmooksResourceConfiguration resourceConfig, T contentHandler) {
        this.addMapping(elementName, new ContentHandlerConfigMap<T>(contentHandler, resourceConfig));
    }

    private void addMapping(String elementName, ContentHandlerConfigMap<T> mapInst) {
        List<ContentHandlerConfigMap<T>> elementMappings = this.table.get(elementName.toLowerCase());
        if (elementMappings == null) {
            elementMappings = new Vector<ContentHandlerConfigMap<T>>();
            this.table.put(elementName.toLowerCase(), elementMappings);
        }
        elementMappings.add(mapInst);
        ++this.count;
        if (!mapInst.getResourceConfig().isDefaultResource()) {
            ++this.userConfiguredCount;
        }
    }

    public void addAll(ContentHandlerConfigMapTable<T> configMap) {
        Set<Map.Entry<String, List<ContentHandlerConfigMap<T>>>> mappingsES = configMap.table.entrySet();
        for (Map.Entry<String, List<ContentHandlerConfigMap<T>>> elementMappings : mappingsES) {
            String elementName = elementMappings.getKey();
            List<ContentHandlerConfigMap<T>> mappingList = elementMappings.getValue();
            for (ContentHandlerConfigMap<T> mapping : mappingList) {
                this.addMapping(elementName, mapping);
            }
        }
    }

    public Map<String, List<ContentHandlerConfigMap<T>>> getTable() {
        return Collections.unmodifiableMap(this.table);
    }

    public List<ContentHandlerConfigMap<T>> getMappings(String selector) {
        return this.table.get(selector.toLowerCase());
    }

    public List<ContentHandlerConfigMap<T>> getMappings(String[] selectors) {
        ArrayList<ContentHandlerConfigMap<T>> combinedList = new ArrayList<ContentHandlerConfigMap<T>>();
        String[] stringArray = selectors;
        int n = selectors.length;
        int n2 = 0;
        while (n2 < n) {
            String selector = stringArray[n2];
            List<ContentHandlerConfigMap<T>> selectorList = this.table.get(selector.toLowerCase());
            if (selectorList != null) {
                combinedList.addAll(selectorList);
            }
            ++n2;
        }
        return combinedList;
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public int getCount() {
        return this.count;
    }

    public int getUserConfiguredCount() {
        return this.userConfiguredCount;
    }

    public void sort(Sorter.SortOrder sortOrder) {
        Set<Map.Entry<String, List<ContentHandlerConfigMap<T>>>> tableEntries = this.table.entrySet();
        for (Map.Entry<String, List<ContentHandlerConfigMap<T>>> tableEntry : tableEntries) {
            Sorter.sort(tableEntry.getValue(), sortOrder);
        }
    }
}

