/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl.xmlschema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeGroupDefinition;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSNotationDeclaration;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSElementDeclaration;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSNamedMap;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSObjectList;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSStringList;
import org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils;
import org.jboss.xb.binding.NamespaceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossXSNamespaceItem
implements XSNamespaceItem {
    private static final Logger log = Logger.getLogger(JBossXSNamespaceItem.class);
    private String schemaNamespace = null;
    private List<String> docLocations = null;
    private Map<String, XSAnnotation> anns = new HashMap<String, XSAnnotation>();
    private Map<String, XSAttributeDeclaration> attrs = new HashMap<String, XSAttributeDeclaration>();
    private Map<String, XSElementDeclaration> elements = new HashMap<String, XSElementDeclaration>();
    private Map<String, XSTypeDefinition> types = new HashMap<String, XSTypeDefinition>();
    private boolean qualifiedElements = false;
    private NamespaceRegistry namespaceRegistry;

    public JBossXSNamespaceItem(String ns, NamespaceRegistry namespaceRegistry, boolean qualifiedElements) {
        this.schemaNamespace = ns;
        this.namespaceRegistry = namespaceRegistry;
        this.qualifiedElements = qualifiedElements;
    }

    public String getSchemaNamespace() {
        return this.schemaNamespace;
    }

    public XSNamedMap getComponents(short objectType) {
        JBossXSNamedMap jbnm = new JBossXSNamedMap();
        if (objectType == 2 && this.elements.size() > 0) {
            jbnm.addItems(this.elements.values());
        } else if (objectType == 1 && this.attrs.size() > 0) {
            jbnm.addItems(this.attrs.values());
        } else if (objectType == 3 && this.types.size() > 0) {
            jbnm.addItems(this.types.values());
        } else if (objectType == 15) {
            Collection<XSTypeDefinition> col = this.types.values();
            jbnm.addItems(this.getTypes(col, (short)15));
        } else if (objectType == 16) {
            Collection<XSTypeDefinition> col = this.types.values();
            jbnm.addItems(this.getTypes(col, (short)16));
        }
        return jbnm;
    }

    public XSObjectList getAnnotations() {
        ArrayList<XSAnnotation> lst = new ArrayList<XSAnnotation>();
        lst.addAll(this.anns.values());
        return new JBossXSObjectList(lst);
    }

    public XSElementDeclaration getElementDeclaration(String name) {
        JBossXSElementDeclaration jbe = null;
        if (this.elements != null) {
            XSElementDeclaration xe = this.elements.get(name);
            if (xe != null && !(xe instanceof JBossXSElementDeclaration)) {
                jbe = new JBossXSElementDeclaration(xe);
            } else {
                return xe;
            }
        }
        return jbe;
    }

    public XSAttributeDeclaration getAttributeDeclaration(String name) {
        if (this.attrs != null) {
            return this.attrs.get(name);
        }
        return null;
    }

    public XSTypeDefinition getTypeDefinition(String name) {
        if (this.types != null) {
            return this.types.get(name);
        }
        return null;
    }

    public XSAttributeGroupDefinition getAttributeGroup(String name) {
        return null;
    }

    public XSModelGroupDefinition getModelGroupDefinition(String name) {
        return null;
    }

    public XSNotationDeclaration getNotationDeclaration(String name) {
        return null;
    }

    public StringList getDocumentLocations() {
        if (this.docLocations == null) {
            return new JBossXSStringList();
        }
        JBossXSStringList strList = new JBossXSStringList(this.docLocations);
        return strList;
    }

    public void addDocumentLocation(String uri) {
        if (this.docLocations == null) {
            this.docLocations = new ArrayList<String>();
        }
        this.docLocations.add(uri);
    }

    public void addDocumentLocations(List<String> uri) {
        if (this.docLocations == null) {
            this.docLocations = new ArrayList<String>();
        }
        this.docLocations.addAll(uri);
    }

    public void addXSAnnotation(XSAnnotation xa) {
        if (xa == null) {
            throw new IllegalArgumentException("Illegal Null Argument:xa");
        }
        this.anns.put(xa.getName(), xa);
    }

    public void addXSAttributeDeclaration(XSAttributeDeclaration att) {
        if (att == null) {
            throw new IllegalArgumentException("att is null");
        }
        this.attrs.put(att.getName(), att);
    }

    public void addXSElementDeclaration(XSElementDeclaration el) {
        if (el == null) {
            throw new IllegalArgumentException("Element is null");
        }
        this.elements.put(el.getName(), el);
    }

    public void addXSTypeDefinition(XSTypeDefinition xsType) {
        if (xsType == null) {
            throw new IllegalArgumentException("type is null");
        }
        String xsTypeName = xsType.getName();
        log.trace((Object)("addXSTypeDefinition: " + xsTypeName));
        this.types.put(xsTypeName, xsType);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        WSSchemaUtils sutils = WSSchemaUtils.getInstance(this.namespaceRegistry, this.schemaNamespace);
        StringBuilder buffer = new StringBuilder();
        buffer.append("<schema  targetNamespace='" + this.schemaNamespace + "'");
        buffer.append(" xmlns:soap11-enc='http://schemas.xmlsoap.org/soap/encoding/'");
        if (!this.schemaNamespace.equals("http://www.w3.org/XML/1998/namespace")) {
            buffer.append(" xmlns:tns='" + this.schemaNamespace + "'");
        }
        buffer.append(" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'");
        buffer.append(" xmlns='http://www.w3.org/2001/XMLSchema'");
        Iterator iter = this.namespaceRegistry.getRegisteredPrefixes();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            String ns = this.namespaceRegistry.getNamespaceURI(prefix);
            if (ns.equals(this.schemaNamespace) && !ns.equals("http://www.w3.org/XML/1998/namespace") || ns.equals("http://schemas.xmlsoap.org/soap/encoding/") || ns.equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
            buffer.append(" xmlns:" + prefix + "='" + ns + "'");
        }
        if (this.qualifiedElements) {
            buffer.append(" elementFormDefault='qualified'");
        }
        buffer.append(">");
        iter = this.namespaceRegistry.getRegisteredURIs();
        while (iter.hasNext()) {
            String ns = (String)iter.next();
            if (ns.equals(this.schemaNamespace) || ns.equals("http://schemas.xmlsoap.org/soap/encoding/") || ns.equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
            buffer.append("<import namespace='" + ns + "'/>");
        }
        TreeSet<String> treeset = new TreeSet<String>(new XSComparator());
        treeset.addAll(this.types.keySet());
        for (String key : treeset) {
            buffer.append(sutils.write(this.types.get(key)));
        }
        treeset = new TreeSet(new XSComparator());
        treeset.addAll(this.elements.keySet());
        for (String key : treeset) {
            buffer.append(sutils.write(this.elements.get(key)));
        }
        buffer.append("</schema>");
        return buffer.toString();
    }

    public void merge(JBossXSNamespaceItem nsi) {
        int i;
        JBossXSNamedMap nmap = (JBossXSNamedMap)nsi.getComponents((short)1);
        int len = nmap.getLength();
        for (i = 0; i < len; ++i) {
            XSAttributeDeclaration xatt = (XSAttributeDeclaration)nmap.item(i);
            this.addXSAttributeDeclaration(xatt);
        }
        nmap = (JBossXSNamedMap)nsi.getComponents((short)3);
        len = nmap.getLength();
        for (i = 0; i < len; ++i) {
            XSTypeDefinition xt = (XSTypeDefinition)nmap.item(i);
            this.addXSTypeDefinition(xt);
        }
        nmap = (JBossXSNamedMap)nsi.getComponents((short)2);
        len = nmap.getLength();
        for (i = 0; i < len; ++i) {
            XSElementDeclaration xe = (XSElementDeclaration)nmap.item(i);
            this.addXSElementDeclaration(xe);
        }
    }

    public void removeXSTypeDefinition(XSTypeDefinition xst) {
        String name = xst.getName();
        this.types.remove(name);
    }

    public void removeXSElementDeclaration(XSElementDeclaration xel) {
        String name = xel.getName();
        this.elements.remove(name);
    }

    public boolean isQualifiedElements() {
        return this.qualifiedElements;
    }

    public void setQualifiedElements(boolean qualifiedElements) {
        this.qualifiedElements = qualifiedElements;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public void setNamespaceRegistry(NamespaceRegistry namespaceRegistry) {
        this.namespaceRegistry = namespaceRegistry;
    }

    private Collection getTypes(Collection col, short objectType) {
        if (objectType != 16 && objectType != 15) {
            throw new IllegalArgumentException("objectType should be simple type or complex type");
        }
        ArrayList values = new ArrayList();
        for (Object obj : col) {
            if (objectType == 15 && obj instanceof XSComplexTypeDefinition) {
                values.add(obj);
                continue;
            }
            if (objectType != 16 || !(obj instanceof XSSimpleTypeDefinition)) continue;
            values.add(obj);
        }
        return values;
    }

    private boolean isEmpty() {
        boolean bool = true;
        if (this.attrs.size() > 0) {
            return false;
        }
        if (this.types.size() > 0) {
            return false;
        }
        if (this.elements.size() > 0) {
            return false;
        }
        return bool;
    }

    private class XSComparator
    implements Comparator {
        private XSComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            String str1 = (String)arg0;
            String str2 = (String)arg1;
            if (Character.isUpperCase(str1.charAt(0)) && Character.isLowerCase(str2.charAt(0))) {
                return 1;
            }
            return str1.compareTo(str2);
        }
    }
}

