/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.util.TypeMatcher;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class SubtypeTypeMatcher
implements TypeMatcher {
    private ReferenceType supertype;

    public SubtypeTypeMatcher(ReferenceType supertype) {
        this.supertype = supertype;
    }

    public SubtypeTypeMatcher(ClassDescriptor classDescriptor) {
        this(ObjectType.getInstance(classDescriptor.toDottedClassName()));
    }

    public boolean matches(Type t) {
        if (!(t instanceof ReferenceType)) {
            return false;
        }
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        Subtypes2 subtypes2 = analysisCache.getDatabase(Subtypes2.class);
        try {
            return subtypes2.isSubtype((ReferenceType)t, this.supertype);
        }
        catch (ClassNotFoundException e) {
            analysisCache.getErrorLogger().reportMissingClass(e);
            return false;
        }
    }

    public String toString() {
        return "+" + this.supertype.toString();
    }
}

