/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.HashList;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.ProjectSettings;
import edu.umd.cs.findbugs.gui2.SortableStringComparator;
import edu.umd.cs.findbugs.gui2.Sortables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugSet
implements Iterable<BugLeafNode> {
    private HashList<BugLeafNode> mainList;
    private HashMap<BugAspects.SortableValue, BugSet> doneMap;
    private HashMap<BugAspects.SortableValue, Boolean> doneContainsMap;
    private HashMap<Sortables, HashList<String>> sortablesToStrings;
    private static BugSet mainBugSet = null;

    public static BugSet getMainBugSet() {
        return mainBugSet;
    }

    public String[] getAll(Sortables s) {
        HashList<String> list = this.sortablesToStrings.get(s);
        Collections.sort(list, new SortableStringComparator(s));
        return list.toArray(new String[list.size()]);
    }

    BugSet(Collection<? extends BugLeafNode> filteredSet) {
        this.mainList = new HashList<BugLeafNode>(filteredSet);
        this.doneMap = new HashMap();
        this.doneContainsMap = new HashMap();
        this.cacheSortables();
    }

    BugSet(BugCollection bugCollection) {
        this(Collections.emptyList());
        Iterator<BugInstance> i = bugCollection.iterator();
        while (i.hasNext()) {
            this.mainList.add(new BugLeafNode(i.next()));
        }
    }

    static void setAsRootAndCache(BugSet bs) {
        mainBugSet = bs;
        bs.sortList();
        bs.cacheSortables();
    }

    void cacheSortables() {
        this.sortablesToStrings = new HashMap();
        for (Sortables key : Sortables.values()) {
            if (key == Sortables.DIVIDER) continue;
            HashList list = new HashList();
            this.sortablesToStrings.put(key, list);
        }
        ArrayList<BugLeafNode> bugNodes = new ArrayList<BugLeafNode>();
        Filter suppressionFilter = ProjectSettings.getInstance().getSuppressionFilter();
        for (BugLeafNode p : this.mainList) {
            if (suppressionFilter.match(p.getBug())) continue;
            bugNodes.add(p);
        }
        for (BugLeafNode b : bugNodes) {
            BugInstance bug = b.getBug();
            BugPattern bugP = bug.getBugPattern();
            if (bugP == null) {
                assert (false);
                if (!MainFrame.DEBUG) continue;
                System.err.println("A bug pattern was not found for " + bug.getMessage());
                continue;
            }
            for (Sortables key : Sortables.values()) {
                String value;
                if (key == Sortables.DIVIDER) continue;
                HashList<String> list = this.sortablesToStrings.get(key);
                if (!list.contains(value = key.getFrom(bug))) {
                    list.add(value);
                }
                this.sortablesToStrings.put(key, list);
            }
        }
        for (Sortables key : Sortables.values()) {
            if (key == Sortables.DIVIDER) continue;
            Collections.sort((List)this.sortablesToStrings.get(key));
        }
    }

    static int countFilteredBugs() {
        Filter cm = ProjectSettings.getInstance().getSuppressionFilter();
        int result = 0;
        for (BugLeafNode bug : BugSet.mainBugSet.mainList) {
            if (!cm.match(bug.getBug())) continue;
            ++result;
        }
        return result;
    }

    BugSet(BugSet copySet) {
        this.mainList = copySet.mainList;
        this.doneMap = new HashMap();
        this.doneContainsMap = new HashMap();
        this.cacheSortables();
    }

    BugSet query(BugAspects.SortableValue keyValuePair) {
        if (this.doneMap.containsKey(keyValuePair)) {
            return this.doneMap.get(keyValuePair);
        }
        ArrayList<BugLeafNode> bugs = new ArrayList<BugLeafNode>();
        for (BugLeafNode b : this.mainList) {
            if (!b.matches(keyValuePair)) continue;
            bugs.add(b);
        }
        BugSet temp = new BugSet(bugs);
        this.doneMap.put(keyValuePair, temp);
        return temp;
    }

    void sortList() {
        final List<Sortables> order = MainFrame.getInstance().getSorter().getOrderAfterDivider();
        Collections.sort(this.mainList, new Comparator<BugLeafNode>(){

            @Override
            public int compare(BugLeafNode one, BugLeafNode two) {
                for (Sortables i : order) {
                    int result = i.getBugLeafNodeComparator().compare(one, two);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        });
    }

    public boolean contains(BugAspects.SortableValue keyValuePair) {
        if (this.doneContainsMap.containsKey(keyValuePair)) {
            return this.doneContainsMap.get(keyValuePair);
        }
        for (BugLeafNode p : this.filterNoCache().mainList) {
            if (!p.matches(keyValuePair)) continue;
            this.doneContainsMap.put(keyValuePair, true);
            return true;
        }
        this.doneContainsMap.put(keyValuePair, false);
        return false;
    }

    public BugSet query(BugAspects a) {
        BugSet result = this;
        for (BugAspects.SortableValue sp : a) {
            result = result.query(sp);
        }
        return result;
    }

    public int sizeUnfiltered() {
        return this.mainList.size();
    }

    public int indexOfUnfiltered(BugLeafNode p) {
        return this.mainList.indexOf(p);
    }

    public BugLeafNode getUnfiltered(int index) {
        return (BugLeafNode)this.mainList.get(index);
    }

    @Override
    public Iterator<BugLeafNode> iterator() {
        return this.mainList.iterator();
    }

    BugSet(ArrayList<BugLeafNode> filteredSet, boolean cacheSortables) {
        this.mainList = new HashList<BugLeafNode>(filteredSet);
        this.doneMap = new HashMap();
        this.doneContainsMap = new HashMap();
        if (cacheSortables) {
            this.cacheSortables();
        }
    }

    public BugSet filterNoCache() {
        Filter m = ProjectSettings.getInstance().getSuppressionFilter();
        ArrayList<BugLeafNode> people = new ArrayList<BugLeafNode>();
        for (BugLeafNode p : this.mainList) {
            if (m.match(p.getBug())) continue;
            people.add(p);
        }
        return new BugSet(people, false);
    }

    public BugSet getBugsMatchingFilter(Matcher m) {
        ArrayList<BugLeafNode> people = new ArrayList<BugLeafNode>();
        for (BugLeafNode p : this.mainList) {
            if (m.match(p.getBug())) continue;
            people.add(p);
        }
        return new BugSet(people, false);
    }

    public int size() {
        return this.filterNoCache().sizeUnfiltered();
    }

    public int indexOf(BugLeafNode p) {
        return this.filterNoCache().indexOfUnfiltered(p);
    }

    public BugLeafNode get(int index) {
        return this.filterNoCache().getUnfiltered(index);
    }
}

