/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ResourceCreationPoint;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ResourceValue;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stream
extends ResourceCreationPoint
implements Comparable<Stream> {
    private String streamBase;
    private boolean isUninteresting;
    private boolean isOpenOnCreation;
    private Location openLocation;
    private boolean ignoreImplicitExceptions;
    private String bugType;
    private int instanceParam;
    private boolean isClosed;

    public String toString() {
        return this.streamBase + ":" + this.openLocation;
    }

    public Stream(Location location, String streamClass, String streamBase) {
        super(location, streamClass);
        this.streamBase = streamBase;
        this.isUninteresting = true;
        this.instanceParam = -1;
    }

    public Stream setInteresting(String bugType) {
        this.isUninteresting = false;
        this.bugType = bugType;
        return this;
    }

    public Stream setIgnoreImplicitExceptions(boolean enable) {
        this.ignoreImplicitExceptions = enable;
        return this;
    }

    public Stream setIsOpenOnCreation(boolean enable) {
        this.isOpenOnCreation = enable;
        return this;
    }

    public void setInstanceParam(int instanceParam) {
        this.instanceParam = instanceParam;
    }

    public void setClosed() {
        this.isClosed = true;
    }

    public String getStreamBase() {
        return this.streamBase;
    }

    public boolean isUninteresting() {
        return this.isUninteresting;
    }

    public boolean isOpenOnCreation() {
        return this.isOpenOnCreation;
    }

    public void setOpenLocation(Location openLocation) {
        this.openLocation = openLocation;
    }

    public Location getOpenLocation() {
        return this.openLocation;
    }

    public boolean ignoreImplicitExceptions() {
        return this.ignoreImplicitExceptions;
    }

    public int getInstanceParam() {
        return this.instanceParam;
    }

    public String getBugType() {
        return this.bugType;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isStreamOpen(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, ResourceValueFrame frame) {
        if (this.isOpenOnCreation) {
            return false;
        }
        Instruction ins = handle.getInstruction();
        if (!(ins instanceof INVOKESPECIAL)) {
            return false;
        }
        INVOKESPECIAL inv = (INVOKESPECIAL)ins;
        return frame.isValid() && this.getInstanceValue(frame, inv, cpg).isInstance() && this.matchMethod(inv, cpg, this.getResourceClass(), "<init>");
    }

    public boolean isStreamClose(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, ResourceValueFrame frame, RepositoryLookupFailureCallback lookupFailureCallback) {
        Instruction ins = handle.getInstruction();
        if (ins instanceof INVOKEVIRTUAL || ins instanceof INVOKEINTERFACE) {
            InvokeInstruction inv = (InvokeInstruction)ins;
            if (!frame.isValid() || !this.getInstanceValue(frame, inv, cpg).isInstance()) {
                return false;
            }
            try {
                return inv.getName(cpg).equals("close") && inv.getSignature(cpg).equals("()V") && Hierarchy.isSubtype(inv.getClassName(cpg), this.streamBase);
            }
            catch (ClassNotFoundException e) {
                lookupFailureCallback.reportMissingClass(e);
                return false;
            }
        }
        return false;
    }

    private ResourceValue getInstanceValue(ResourceValueFrame frame, InvokeInstruction inv, ConstantPoolGen cpg) {
        int numConsumed = inv.consumeStack(cpg);
        if (numConsumed == -2) {
            throw new IllegalStateException();
        }
        return (ResourceValue)frame.getValue(frame.getNumSlots() - numConsumed);
    }

    private boolean matchMethod(InvokeInstruction inv, ConstantPoolGen cpg, String className, String methodName) {
        return inv.getClassName(cpg).equals(className) && inv.getName(cpg).equals(methodName);
    }

    public int hashCode() {
        return this.getLocation().hashCode() + 3 * this.streamBase.hashCode() + 7 * this.getResourceClass().hashCode() + 11 * this.instanceParam;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Stream)) {
            return false;
        }
        Stream other = (Stream)o;
        if (!this.getLocation().equals(other.getLocation())) {
            return false;
        }
        if (!this.streamBase.equals(other.streamBase)) {
            return false;
        }
        if (!this.getResourceClass().equals(other.getResourceClass())) {
            return false;
        }
        return this.instanceParam == other.instanceParam;
    }

    @Override
    public int compareTo(Stream other) {
        int cmp = this.getLocation().compareTo(other.getLocation());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.streamBase.compareTo(other.streamBase);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getResourceClass().compareTo(other.getResourceClass());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.instanceParam - other.instanceParam;
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }
}

