/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine;

import edu.umd.cs.findbugs.asm.FBClassReader;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.util.MultiMap;
import java.util.HashSet;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelfMethodCalls {
    private final ClassReader classReader;

    private static boolean interestingSignature(String desc2) {
        int firstL = desc2.indexOf(76);
        int firstArray = desc2.indexOf(91);
        int firstRParen = desc2.indexOf(41);
        if (firstL >= 0 && firstL < firstRParen) {
            return true;
        }
        return firstArray >= 0 && firstArray < firstRParen;
    }

    public static <T> MultiMap<T, T> getSelfCalls(final ClassDescriptor classDescriptor, final Map<String, T> methods) {
        FBClassReader reader;
        final MultiMap map = new MultiMap(HashSet.class);
        try {
            reader = Global.getAnalysisCache().getClassAnalysis(FBClassReader.class, classDescriptor);
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error finding self method calls for " + classDescriptor, e);
            return map;
        }
        reader.accept((ClassVisitor)new EmptyVisitor(){

            public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
                return new EmptyVisitor(){

                    public void visitMethodInsn(int opcode, String owner, String name2, String desc2) {
                        if (owner.equals(classDescriptor.getClassName()) && SelfMethodCalls.interestingSignature(desc2)) {
                            map.add(methods.get(name + desc + ((access & 8) != 0)), methods.get(name2 + desc2 + (opcode == 184)));
                        }
                    }
                };
            }
        }, 6);
        return map;
    }

    public SelfMethodCalls(ClassReader classReader) {
        this.classReader = classReader;
    }
}

