/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnnotationDatabase;
import edu.umd.cs.findbugs.ba.DefaultNullnessAnnotations;
import edu.umd.cs.findbugs.ba.INullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;
import edu.umd.cs.findbugs.log.Profiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullnessAnnotationDatabase
extends AnnotationDatabase<NullnessAnnotation>
implements INullnessAnnotationDatabase {
    public NullnessAnnotationDatabase() {
        this.setAddClassOnly(true);
        this.loadAuxiliaryAnnotations();
        this.setAddClassOnly(false);
    }

    @Override
    public void loadAuxiliaryAnnotations() {
        DefaultNullnessAnnotations.addDefaultNullnessAnnotations(this);
    }

    @Override
    public boolean parameterMustBeNonNull(XMethod m, int param) {
        if (!this.anyAnnotations(NullnessAnnotation.NONNULL)) {
            return false;
        }
        XMethodParameter xmp = new XMethodParameter(m, param);
        NullnessAnnotation resolvedAnnotation = this.getResolvedAnnotation(xmp, true);
        return resolvedAnnotation == NullnessAnnotation.NONNULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public NullnessAnnotation getResolvedAnnotation(Object o, boolean getMinimal) {
        Profiler profiler = Profiler.getInstance();
        profiler.start(this.getClass());
        try {
            NullnessAnnotation result;
            XField f;
            if (o instanceof XMethodParameter) {
                XMethodParameter mp = (XMethodParameter)o;
                XMethod m = mp.getMethod();
                if (m.getName().startsWith("access$")) {
                    NullnessAnnotation nullnessAnnotation = null;
                    return nullnessAnnotation;
                }
                if (mp.getParameterNumber() == 0 && m.getName().equals("equals") && m.getSignature().equals("(Ljava/lang/Object;)Z") && !m.isStatic()) {
                    NullnessAnnotation nullnessAnnotation = NullnessAnnotation.CHECK_FOR_NULL;
                    return nullnessAnnotation;
                }
                if (mp.getParameterNumber() == 0 && m.getName().equals("compareTo") && m.getSignature().endsWith(";)Z") && !m.isStatic()) {
                    NullnessAnnotation nullnessAnnotation = NullnessAnnotation.NONNULL;
                    return nullnessAnnotation;
                }
            } else if (o instanceof XMethod) {
                XMethod m = (XMethod)o;
                if (m.getName().startsWith("access$")) {
                    NullnessAnnotation nullnessAnnotation = null;
                    return nullnessAnnotation;
                }
                if (m.getName().equals("clone") && m.getSignature().equals("()Ljava/lang/Object;")) {
                    NullnessAnnotation nullnessAnnotation = NullnessAnnotation.NONNULL;
                    return nullnessAnnotation;
                }
                if (m.getName().equals("toString") && m.getSignature().equals("()Ljava/lang/String;")) {
                    NullnessAnnotation nullnessAnnotation = NullnessAnnotation.NONNULL;
                    return nullnessAnnotation;
                }
            } else if (o instanceof XField && (f = (XField)o).getName().startsWith("this$")) {
                NullnessAnnotation nullnessAnnotation = NullnessAnnotation.NONNULL;
                return nullnessAnnotation;
            }
            NullnessAnnotation nullnessAnnotation = result = (NullnessAnnotation)super.getResolvedAnnotation(o, getMinimal);
            return nullnessAnnotation;
        }
        finally {
            profiler.end(this.getClass());
        }
    }

    @Override
    public void addDefaultMethodAnnotation(String name, NullnessAnnotation annotation) {
        super.addDefaultMethodAnnotation(name, annotation);
    }

    @Override
    public void addDefaultAnnotation(AnnotationDatabase.Target target, String c, NullnessAnnotation n) {
        super.addDefaultAnnotation(target, c, n);
    }

    @Override
    public void addFieldAnnotation(String name, String name2, String sig, boolean isStatic, NullnessAnnotation annotation) {
        super.addFieldAnnotation(name, name2, sig, isStatic, annotation);
    }

    @Override
    public void addMethodAnnotation(String name, String name2, String sig, boolean isStatic, NullnessAnnotation annotation) {
        super.addMethodAnnotation(name, name2, sig, isStatic, annotation);
    }

    @Override
    public void addMethodParameterAnnotation(String name, String name2, String sig, boolean isStatic, int param, NullnessAnnotation annotation) {
        super.addMethodParameterAnnotation(name, name2, sig, isStatic, param, annotation);
    }
}

