/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.FtpWriter;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.interfaces.Command;
import org.apache.ftpserver.interfaces.CommandFactory;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.IpRestrictor;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.listener.ConnectionManager;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpProtocolHandler {
    private final Logger LOG = LoggerFactory.getLogger((Class)FtpProtocolHandler.class);
    protected FtpServerContext serverContext;

    public FtpProtocolHandler(FtpServerContext serverContext) throws IOException {
        this.serverContext = serverContext;
    }

    public void onConnectionOpened(Connection connection, FtpSessionImpl session, FtpWriter writer) throws Exception {
        InetAddress clientAddr = session.getClientAddress();
        ConnectionManager conManager = this.serverContext.getConnectionManager();
        Ftplet ftpletContainer = this.serverContext.getFtpletContainer();
        if (conManager == null) {
            return;
        }
        if (ftpletContainer == null) {
            return;
        }
        String hostAddress = clientAddr.getHostAddress();
        this.LOG.info("Open connection - " + hostAddress);
        ServerFtpStatistics ftpStat = (ServerFtpStatistics)this.serverContext.getFtpStatistics();
        ftpStat.setOpenConnection(connection);
        boolean isSkipped = false;
        FtpletEnum ftpletRet = ftpletContainer.onConnect((FtpSession)session, (FtpReplyOutput)writer);
        if (ftpletRet == FtpletEnum.RET_SKIP) {
            isSkipped = true;
        } else if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
            conManager.closeConnection(connection);
            return;
        }
        if (!isSkipped) {
            IpRestrictor ipRestrictor = this.serverContext.getIpRestrictor();
            if (!ipRestrictor.hasPermission(clientAddr)) {
                this.LOG.warn("No permission to access from " + hostAddress);
                writer.write(FtpReplyUtil.translate(session, 530, "ip.restricted", null));
                return;
            }
            int maxConnections = conManager.getMaxConnections();
            if (maxConnections != 0 && ftpStat.getCurrentConnectionNumber() > maxConnections) {
                this.LOG.warn("Maximum connection limit reached.");
                writer.write(FtpReplyUtil.translate(session, 530, "connection.limit", null));
                return;
            }
            writer.write(FtpReplyUtil.translate(session, 220, null, null));
        }
    }

    public void onRequestReceived(Connection connection, FtpSessionImpl session, FtpWriter writer, FtpRequest request) throws IOException, FtpException {
        session.setCurrentRequest(request);
        if (!this.hasPermission(session, request)) {
            writer.write(FtpReplyUtil.translate(session, 530, "permission", null));
            return;
        }
        this.service(connection, request, session, writer);
        if (session != null) {
            session.setCurrentRequest(null);
        }
    }

    public void onConnectionClosed(Connection connection, FtpSessionImpl session, FtpWriter writer) {
        try {
            Ftplet ftpletContainer = this.serverContext.getFtpletContainer();
            if (ftpletContainer != null) {
                ftpletContainer.onDisconnect((FtpSession)session, (FtpReplyOutput)writer);
            }
        }
        catch (Exception ex) {
            this.LOG.warn("RequestHandler.close()", (Throwable)ex);
        }
        ServerFtpStatistics ftpStat = (ServerFtpStatistics)this.serverContext.getFtpStatistics();
        if (session != null) {
            User user = session.getUser();
            String userName = user != null ? user.getName() : "<Not logged in>";
            InetAddress clientAddr = session.getClientAddress();
            this.LOG.info("Close connection : " + clientAddr.getHostAddress() + " - " + userName);
            if (session.isLoggedIn()) {
                session.setLogout();
                if (ftpStat != null) {
                    ftpStat.setLogout(connection);
                }
            }
            if (ftpStat != null) {
                ftpStat.setCloseConnection(connection);
            }
            session.clear();
            session.getServerDataConnection().dispose();
            FileSystemView fview = session.getFileSystemView();
            if (fview != null) {
                fview.dispose();
            }
            session = null;
        }
        if (writer != null) {
            writer.setObserver(null);
            writer.close();
            writer = null;
        }
    }

    private void service(Connection connection, FtpRequest request, FtpSessionImpl session, FtpWriter out) throws IOException, FtpException {
        try {
            String commandName = request.getCommand();
            CommandFactory commandFactory = this.serverContext.getCommandFactory();
            Command command = commandFactory.getCommand(commandName);
            if (command != null) {
                command.execute(connection, request, session, out);
            } else {
                out.write(FtpReplyUtil.translate(session, 502, "not.implemented", null));
            }
        }
        catch (Exception ex) {
            try {
                out.write(FtpReplyUtil.translate(session, 550, null, null));
            }
            catch (Exception ex1) {
                // empty catch block
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            this.LOG.warn("RequestHandler.service()", (Throwable)ex);
        }
    }

    private boolean hasPermission(FtpSession session, FtpRequest request) {
        String cmd = request.getCommand();
        if (cmd == null) {
            return false;
        }
        return session.isLoggedIn() || cmd.equals("USER") || cmd.equals("PASS") || cmd.equals("QUIT") || cmd.equals("AUTH") || cmd.equals("HELP") || cmd.equals("SYST") || cmd.equals("FEAT") || cmd.equals("PBSZ") || cmd.equals("PROT") || cmd.equals("LANG") || cmd.equals("ACCT");
    }
}

