/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.commandline;

import java.io.FileInputStream;
import org.apache.ftpserver.ConfigurableFtpServerContext;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.config.PropertiesConfiguration;
import org.apache.ftpserver.config.XmlConfigurationHandler;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.EmptyConfiguration;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Daemon {
    private static final Logger LOG = LoggerFactory.getLogger((Class)Daemon.class);
    private static FtpServer server;
    private static Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block12: {
            try {
                Object object;
                if (server == null) {
                    Configuration config = Daemon.getConfiguration(args);
                    if (config == null) {
                        LOG.error("No configuration provided");
                        throw new FtpException("No configuration provided");
                    }
                    ConfigurableFtpServerContext serverContext = new ConfigurableFtpServerContext(config);
                    server = new FtpServer(serverContext);
                }
                String command = "start";
                if (args != null && args.length > 0) {
                    command = args[0];
                }
                if (command.equals("start")) {
                    LOG.info("Starting FTP server daemon");
                    server.start();
                    object = lock;
                    synchronized (object) {
                        lock.wait();
                        break block12;
                    }
                }
                if (!command.equals("stop")) break block12;
                object = lock;
                synchronized (object) {
                    lock.notify();
                }
                LOG.info("Stopping FTP server daemon");
                server.stop();
            }
            catch (Throwable t) {
                LOG.error("Daemon error", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Configuration getConfiguration(String[] args) throws Exception {
        Object config;
        block7: {
            config = null;
            FileInputStream in = null;
            try {
                if (args == null || args.length < 2) {
                    LOG.info("Using default configuration....");
                    config = EmptyConfiguration.INSTANCE;
                    break block7;
                }
                if (args.length == 2 && args[1].equals("-default")) {
                    LOG.info("Using default configuration....");
                    config = EmptyConfiguration.INSTANCE;
                    break block7;
                }
                if (args.length == 3 && args[1].equals("-xml")) {
                    LOG.info("Using xml configuration file " + args[2] + "...");
                    in = new FileInputStream(args[2]);
                    XmlConfigurationHandler xmlHandler = new XmlConfigurationHandler(in);
                    config = xmlHandler.parse();
                    break block7;
                }
                if (args.length == 3 && args[1].equals("-prop")) {
                    LOG.info("Using properties configuration file " + args[2] + "...");
                    in = new FileInputStream(args[2]);
                    config = new PropertiesConfiguration(in);
                    break block7;
                }
                throw new FtpException("Invalid configuration option");
            }
            finally {
                IoUtils.close(in);
            }
        }
        return config;
    }

    static {
        lock = new Object();
    }
}

