/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STOR
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)STOR.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        block31: {
            try {
                DataConnection dataConnection;
                FtpletEnum ftpletRet;
                long skipLen = session.getFileOffset();
                FtpServerContext serverContext = connection.getServerContext();
                String fileName = request.getArgument();
                if (fileName == null) {
                    out.write(FtpReplyUtil.translate(session, 501, "STOR", null));
                    return;
                }
                Ftplet ftpletContainer = serverContext.getFtpletContainer();
                try {
                    ftpletRet = ftpletContainer.onUploadStart((FtpSession)session, request, out);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_SKIP) {
                    return;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    serverContext.getConnectionManager().closeConnection(connection);
                    return;
                }
                FileObject file = null;
                try {
                    file = session.getFileSystemView().getFileObject(fileName);
                }
                catch (Exception ex) {
                    this.LOG.debug("Exception getting file object", (Throwable)ex);
                }
                if (file == null) {
                    out.write(FtpReplyUtil.translate(session, 550, "STOR.invalid", fileName));
                    return;
                }
                fileName = file.getFullName();
                if (!file.hasWritePermission()) {
                    out.write(FtpReplyUtil.translate(session, 550, "STOR.permission", fileName));
                    return;
                }
                out.write(FtpReplyUtil.translate(session, 150, "STOR", fileName));
                try {
                    dataConnection = session.getDataConnection().openConnection();
                }
                catch (Exception e) {
                    this.LOG.debug("Exception getting the input data stream", (Throwable)e);
                    out.write(FtpReplyUtil.translate(session, 425, "STOR", fileName));
                    session.resetState();
                    session.getDataConnection().closeDataConnection();
                    return;
                }
                boolean failure = false;
                OutputStream outStream = null;
                try {
                    outStream = file.createOutputStream(skipLen);
                    long transSz = dataConnection.transferFromClient(outStream);
                    String userName = session.getUser().getName();
                    this.LOG.info("File upload : " + userName + " - " + fileName);
                    ServerFtpStatistics ftpStat = (ServerFtpStatistics)serverContext.getFtpStatistics();
                    ftpStat.setUpload(connection, file, transSz);
                }
                catch (SocketException ex) {
                    this.LOG.debug("Socket exception during data transfer", (Throwable)ex);
                    failure = true;
                    out.write(FtpReplyUtil.translate(session, 426, "STOR", fileName));
                }
                catch (IOException ex) {
                    this.LOG.debug("IOException during data transfer", (Throwable)ex);
                    failure = true;
                    out.write(FtpReplyUtil.translate(session, 551, "STOR", fileName));
                }
                finally {
                    IoUtils.close(outStream);
                }
                if (failure) break block31;
                out.write(FtpReplyUtil.translate(session, 226, "STOR", fileName));
                try {
                    ftpletRet = ftpletContainer.onUploadEnd((FtpSession)session, request, out);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    serverContext.getConnectionManager().closeConnection(connection);
                    return;
                }
            }
            finally {
                session.resetState();
                session.getDataConnection().closeDataConnection();
            }
        }
    }
}

