/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.net.InetAddress;
import java.util.Date;
import java.util.Hashtable;
import org.apache.ftpserver.ftplet.Component;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.interfaces.FileObserver;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.interfaces.StatisticsObserver;
import org.apache.ftpserver.listener.Connection;

public class FtpStatisticsImpl
implements ServerFtpStatistics,
Component {
    private StatisticsObserver observer = null;
    private FileObserver fileObserver = null;
    private Date startTime = new Date();
    private int uploadCount = 0;
    private int downloadCount = 0;
    private int deleteCount = 0;
    private int mkdirCount = 0;
    private int rmdirCount = 0;
    private int currLogins = 0;
    private int totalLogins = 0;
    private int totalFailedLogins = 0;
    private int currAnonLogins = 0;
    private int totalAnonLogins = 0;
    private int currConnections = 0;
    private int totalConnections = 0;
    private long bytesUpload = 0L;
    private long bytesDownload = 0L;
    Hashtable userLoginTable = new Hashtable();
    public static final String LOGIN_NUMBER = "login_number";

    public void configure(Configuration conf) throws FtpException {
    }

    public void dispose() {
    }

    public void setObserver(StatisticsObserver observer) {
        this.observer = observer;
    }

    public void setFileObserver(FileObserver observer) {
        this.fileObserver = observer;
    }

    public Date getStartTime() {
        return (Date)this.startTime.clone();
    }

    public int getTotalUploadNumber() {
        return this.uploadCount;
    }

    public int getTotalDownloadNumber() {
        return this.downloadCount;
    }

    public int getTotalDeleteNumber() {
        return this.deleteCount;
    }

    public long getTotalUploadSize() {
        return this.bytesUpload;
    }

    public long getTotalDownloadSize() {
        return this.bytesDownload;
    }

    public int getTotalDirectoryCreated() {
        return this.mkdirCount;
    }

    public int getTotalDirectoryRemoved() {
        return this.mkdirCount;
    }

    public int getTotalConnectionNumber() {
        return this.totalConnections;
    }

    public int getCurrentConnectionNumber() {
        return this.currConnections;
    }

    public int getTotalLoginNumber() {
        return this.totalLogins;
    }

    public int getTotalFailedLoginNumber() {
        return this.totalFailedLogins;
    }

    public int getCurrentLoginNumber() {
        return this.currLogins;
    }

    public int getTotalAnonymousLoginNumber() {
        return this.totalAnonLogins;
    }

    public int getCurrentAnonymousLoginNumber() {
        return this.currAnonLogins;
    }

    public int getCurrentUserLoginNumber(User user) {
        Hashtable statisticsTable = (Hashtable)this.userLoginTable.get(user.getName());
        if (statisticsTable == null) {
            return 0;
        }
        Integer loginNumber = (Integer)statisticsTable.get(LOGIN_NUMBER);
        if (loginNumber == null) {
            return 0;
        }
        return loginNumber;
    }

    public int getCurrentUserLoginNumber(User user, InetAddress ipAddress) {
        Hashtable statisticsTable = (Hashtable)this.userLoginTable.get(user.getName());
        if (statisticsTable == null) {
            return 0;
        }
        Integer loginNumber = (Integer)statisticsTable.get(ipAddress.getHostAddress());
        if (loginNumber == null) {
            return 0;
        }
        return loginNumber;
    }

    public void setUpload(Connection connection, FileObject file, long size) {
        ++this.uploadCount;
        this.bytesUpload += size;
        this.notifyUpload(connection, file, size);
    }

    public void setDownload(Connection connection, FileObject file, long size) {
        ++this.downloadCount;
        this.bytesDownload += size;
        this.notifyDownload(connection, file, size);
    }

    public void setDelete(Connection connection, FileObject file) {
        ++this.deleteCount;
        this.notifyDelete(connection, file);
    }

    public void setMkdir(Connection connection, FileObject file) {
        ++this.mkdirCount;
        this.notifyMkdir(connection, file);
    }

    public void setRmdir(Connection connection, FileObject file) {
        ++this.rmdirCount;
        this.notifyRmdir(connection, file);
    }

    public void setOpenConnection(Connection connection) {
        ++this.currConnections;
        ++this.totalConnections;
        this.notifyOpenConnection(connection);
    }

    public void setCloseConnection(Connection connection) {
        if (this.currConnections > 0) {
            --this.currConnections;
        }
        this.notifyCloseConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogin(Connection connection) {
        ++this.currLogins;
        ++this.totalLogins;
        User user = connection.getSession().getUser();
        if ("anonymous".equals(user.getName())) {
            ++this.currAnonLogins;
            ++this.totalAnonLogins;
        }
        User user2 = user;
        synchronized (user2) {
            Hashtable<String, Integer> statisticsTable = (Hashtable<String, Integer>)this.userLoginTable.get(user.getName());
            if (statisticsTable == null) {
                statisticsTable = new Hashtable<String, Integer>();
                this.userLoginTable.put(user.getName(), statisticsTable);
                statisticsTable.put(LOGIN_NUMBER, new Integer(1));
                statisticsTable.put(connection.getSession().getClientAddress().getHostAddress(), new Integer(1));
            } else {
                Integer loginNumber = (Integer)statisticsTable.get(LOGIN_NUMBER);
                statisticsTable.put(LOGIN_NUMBER, new Integer(loginNumber + 1));
                Integer loginNumberPerIP = (Integer)statisticsTable.get(connection.getSession().getClientAddress().getHostAddress());
                if (loginNumberPerIP == null) {
                    statisticsTable.put(connection.getSession().getClientAddress().getHostAddress(), new Integer(1));
                } else {
                    statisticsTable.put(connection.getSession().getClientAddress().getHostAddress(), new Integer(loginNumberPerIP + 1));
                }
            }
        }
        this.notifyLogin(connection);
    }

    public void setLoginFail(Connection connection) {
        ++this.totalFailedLogins;
        this.notifyLoginFail(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogout(Connection connection) {
        --this.currLogins;
        User user = connection.getSession().getUser();
        if ("anonymous".equals(user.getName())) {
            --this.currAnonLogins;
        }
        User user2 = user;
        synchronized (user2) {
            Hashtable statisticsTable = (Hashtable)this.userLoginTable.get(user.getName());
            Integer loginNumber = (Integer)statisticsTable.get(LOGIN_NUMBER);
            statisticsTable.put(LOGIN_NUMBER, new Integer(loginNumber - 1));
            Integer loginNumberPerIP = (Integer)statisticsTable.get(connection.getSession().getClientAddress().getHostAddress());
            if (loginNumberPerIP != null) {
                if (loginNumberPerIP <= 1) {
                    statisticsTable.remove(connection.getSession().getClientAddress().getHostAddress());
                }
            } else {
                statisticsTable.put(connection.getSession().getClientAddress().getHostAddress(), new Integer(loginNumberPerIP - 1));
            }
        }
        this.notifyLogout(connection);
    }

    private void notifyUpload(Connection connection, FileObject file, long size) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyUpload();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyUpload(connection, file, size);
        }
    }

    private void notifyDownload(Connection connection, FileObject file, long size) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyDownload();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyDownload(connection, file, size);
        }
    }

    private void notifyDelete(Connection connection, FileObject file) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyDelete();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyDelete(connection, file);
        }
    }

    private void notifyMkdir(Connection connection, FileObject file) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyMkdir();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyMkdir(connection, file);
        }
    }

    private void notifyRmdir(Connection connection, FileObject file) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyRmdir();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyRmdir(connection, file);
        }
    }

    private void notifyOpenConnection(Connection connection) {
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyOpenConnection();
        }
    }

    private void notifyCloseConnection(Connection connection) {
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyCloseConnection();
        }
    }

    private void notifyLogin(Connection connection) {
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            User user = connection.getSession().getUser();
            boolean anonymous = false;
            if (user != null) {
                String login = user.getName();
                anonymous = login != null && login.equals("anonymous");
            }
            observer.notifyLogin(anonymous);
        }
    }

    private void notifyLoginFail(Connection connection) {
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyLoginFail(connection.getSession().getClientAddress());
        }
    }

    private void notifyLogout(Connection connection) {
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            User user = connection.getSession().getUser();
            boolean anonymous = false;
            if (user != null) {
                String login = user.getName();
                anonymous = login != null && login.equals("anonymous");
            }
            observer.notifyLogout(anonymous);
        }
    }

    public void resetStatisticsCounters() {
        this.startTime = new Date();
        this.uploadCount = 0;
        this.downloadCount = 0;
        this.deleteCount = 0;
        this.mkdirCount = 0;
        this.rmdirCount = 0;
        this.totalLogins = 0;
        this.totalFailedLogins = 0;
        this.totalAnonLogins = 0;
        this.totalConnections = 0;
        this.bytesUpload = 0L;
        this.bytesDownload = 0L;
    }
}

