/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.server.endpoint.advised.SessionAdvised;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.messaging.core.impl.message.MessageFactory;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.invocation.OnewayInvocation;

public class SessionSendRequest
extends RequestSupport {
    private JBossMessage msg;
    private boolean checkForDuplicates;
    private boolean oneway;
    private long sequence;

    public SessionSendRequest() {
    }

    public SessionSendRequest(String objectId, byte version, JBossMessage msg, boolean checkForDuplicates, boolean oneway, long sequence) {
        super(objectId, 312, version);
        this.msg = msg;
        this.checkForDuplicates = checkForDuplicates;
        this.oneway = oneway;
        this.sequence = sequence;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        byte messageType = is.readByte();
        this.msg = (JBossMessage)MessageFactory.createMessage(messageType);
        this.msg.read(is);
        this.checkForDuplicates = is.readBoolean();
        this.oneway = is.readBoolean();
        this.sequence = is.readLong();
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionAdvised advised = (SessionAdvised)Dispatcher.instance.getTarget(this.objectId);
        if (advised != null) {
            advised.send(this.msg, this.checkForDuplicates, this.sequence);
        } else if (!this.oneway) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        return null;
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeByte(this.msg.getType());
        this.msg.write(os);
        os.writeBoolean(this.checkForDuplicates);
        os.writeBoolean(this.oneway);
        os.writeLong(this.sequence);
        os.flush();
    }

    public Object getPayload() {
        if (this.oneway) {
            OnewayInvocation oi = new OnewayInvocation((Object)this);
            InvocationRequest request = new InvocationRequest(null, "JMS", (Object)oi, ONE_WAY_METADATA, null, null);
            return request;
        }
        return super.getPayload();
    }
}

