/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import org.jcp.xml.dsig.internal.dom.DOMSignatureProperty;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMSignatureProperties
extends DOMStructure
implements SignatureProperties {
    private final String id;
    private final List properties;

    public DOMSignatureProperties(List list, String string2) {
        if (list == null) {
            throw new NullPointerException("properties cannot be null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("properties cannot be empty");
        }
        ArrayList arrayList = new ArrayList(list);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (arrayList.get(i) instanceof SignatureProperty) continue;
            throw new ClassCastException("properties[" + i + "] is not a valid type");
        }
        this.properties = Collections.unmodifiableList(arrayList);
        this.id = string2;
    }

    public DOMSignatureProperties(Element element) throws MarshalException {
        this.id = DOMUtils.getAttributeValue(element, "Id");
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<DOMSignatureProperty> arrayList = new ArrayList<DOMSignatureProperty>(n);
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            arrayList.add(new DOMSignatureProperty((Element)node));
        }
        if (arrayList.isEmpty()) {
            throw new MarshalException("properties cannot be empty");
        }
        this.properties = Collections.unmodifiableList(arrayList);
    }

    public List getProperties() {
        return this.properties;
    }

    public String getId() {
        return this.id;
    }

    public void marshal(Node node, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(node);
        Element element = DOMUtils.createElement(document, "SignatureProperties", "http://www.w3.org/2000/09/xmldsig#", string2);
        DOMUtils.setAttributeID(element, "Id", this.id);
        int n = this.properties.size();
        for (int i = 0; i < n; ++i) {
            DOMSignatureProperty dOMSignatureProperty = (DOMSignatureProperty)this.properties.get(i);
            dOMSignatureProperty.marshal(element, string2, dOMCryptoContext);
        }
        node.appendChild(element);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SignatureProperties)) {
            return false;
        }
        SignatureProperties signatureProperties = (SignatureProperties)object;
        boolean bl = this.id == null ? signatureProperties.getId() == null : this.id.equals(signatureProperties.getId());
        return ((Object)this.properties).equals(signatureProperties.getProperties()) && bl;
    }
}

