/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import java.util.Hashtable;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NonceCache
extends TimerTask {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private Hashtable nonceCache = new Hashtable();
    private Hashtable oldNonceCache = new Hashtable();
    private long MAX_NONCE_AGE = 900000L;
    private boolean scheduledFlag = false;
    private boolean canceledFlag = false;

    public NonceCache() {
    }

    public NonceCache(long maxNonceAge) {
        this.MAX_NONCE_AGE = maxNonceAge;
    }

    public boolean validateAndCacheNonce(String nonce, String created) {
        if (this.nonceCache.containsKey(nonce) || this.oldNonceCache.containsKey(nonce)) {
            log.log(Level.INFO, "Nonce Cache already contains the new Nonce Value received :" + nonce);
            return false;
        }
        this.nonceCache.put(nonce, created);
        return true;
    }

    public boolean isScheduled() {
        return this.scheduledFlag;
    }

    public void scheduled(boolean flag) {
        this.scheduledFlag = flag;
    }

    public boolean wasCanceled() {
        return this.canceledFlag;
    }

    public void run() {
        if (this.nonceCache.size() == 0) {
            return;
        }
        this.oldNonceCache.clear();
        Hashtable temp = this.nonceCache;
        this.nonceCache = this.oldNonceCache;
        this.oldNonceCache = temp;
    }

    public boolean cancel() {
        boolean ret = super.cancel();
        this.canceledFlag = true;
        this.oldNonceCache.clear();
        this.nonceCache.clear();
        return ret;
    }

    public long getMaxNonceAge() {
        return this.MAX_NONCE_AGE;
    }
}

