/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.sequence;

import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rm.runtime.sequence.IllegalMessageIdentifierException;
import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rm.runtime.sequence.SequenceData;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InboundSequence
extends AbstractSequence {
    private static final RmLogger LOGGER = RmLogger.getLogger(InboundSequence.class);

    public InboundSequence(SequenceData data) {
        super(data);
    }

    @Override
    public long getLastMessageId() {
        return this.data.getLastMessageId();
    }

    @Override
    public void acknowledgeMessageIds(List<Sequence.AckRange> ranges) throws IllegalMessageIdentifierException {
        for (Sequence.AckRange range : ranges) {
            for (long index = range.lower; index <= range.upper; ++index) {
                this.acknowledgeMessageId(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledgeMessageId(long messageId) throws IllegalMessageIdentifierException {
        try {
            this.data.acquireMessageIdDataReadWriteLock();
            if (messageId > this.data.getLastMessageId()) {
                if (this.data.getLastMessageId() + 1L != messageId) {
                    for (long lostMessageId = this.data.getLastMessageId() + 1L; lostMessageId < messageId; ++lostMessageId) {
                        this.data.addUnackedMessageId(lostMessageId);
                    }
                }
                this.data.updateLastMessageId(messageId);
            } else if (this.data.getLastMessageId() == messageId && !this.data.removeUnackedMessageId(messageId)) {
                throw LOGGER.logSevereException(new IllegalMessageIdentifierException(messageId));
            }
        }
        finally {
            this.data.releaseMessageIdDataReadWriteLock();
        }
    }
}

