/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.sequence;

import com.sun.xml.ws.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rm.runtime.sequence.InMemorySequenceData;
import com.sun.xml.ws.rm.runtime.sequence.InboundSequence;
import com.sun.xml.ws.rm.runtime.sequence.OutboundSequence;
import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rm.runtime.sequence.UnknownSequenceException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DefaultInMemorySequenceManager
implements SequenceManager {
    private final Map<String, Sequence> sequences = new HashMap<String, Sequence>();
    private final ReadWriteLock sequenceLock = new ReentrantReadWriteLock();

    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        try {
            this.sequenceLock.readLock().lock();
            if (this.sequences.containsKey(sequenceId)) {
                Sequence sequence = this.sequences.get(sequenceId);
                return sequence;
            }
            throw new UnknownSequenceException(sequenceId);
        }
        finally {
            this.sequenceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(String sequenceId) {
        try {
            this.sequenceLock.readLock().lock();
            boolean bl = this.sequences.containsKey(sequenceId);
            return bl;
        }
        finally {
            this.sequenceLock.readLock().unlock();
        }
    }

    public Sequence createOutboudSequence(String sequenceId, long expirationTime) throws DuplicateSequenceException {
        InMemorySequenceData data = new InMemorySequenceData(new LinkedList<Long>(), sequenceId, expirationTime, 0L, Sequence.Status.CREATING, false);
        return this.registerSequence(new OutboundSequence(data));
    }

    public Sequence createInboundSequence(String sequenceId, long expirationTime) throws DuplicateSequenceException {
        InMemorySequenceData data = new InMemorySequenceData(new TreeSet<Long>(), sequenceId, expirationTime, 0L, Sequence.Status.CREATING, false);
        return this.registerSequence(new InboundSequence(data));
    }

    public String generateSequenceUID() {
        return "uuid:" + UUID.randomUUID();
    }

    public void closeSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        sequence.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateSequence(String sequenceId) throws UnknownSequenceException {
        block4: {
            try {
                this.sequenceLock.writeLock().lock();
                if (this.sequences.containsKey(sequenceId)) {
                    Sequence sequence = this.sequences.remove(sequenceId);
                    sequence.preDestroy();
                    break block4;
                }
                throw new UnknownSequenceException(sequenceId);
            }
            finally {
                this.sequenceLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence registerSequence(Sequence sequence) throws DuplicateSequenceException {
        try {
            this.sequenceLock.writeLock().lock();
            if (this.sequences.containsKey(sequence.getId())) {
                throw new DuplicateSequenceException(sequence.getId());
            }
            this.sequences.put(sequence.getId(), sequence);
            Sequence sequence2 = sequence;
            return sequence2;
        }
        finally {
            this.sequenceLock.writeLock().unlock();
        }
    }
}

