/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.x509;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509DataContent;
import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509IssuerSerial
extends SignatureElementProxy
implements XMLX509DataContent {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$keys$content$x509$XMLX509IssuerSerial == null ? (class$com$sun$org$apache$xml$internal$security$keys$content$x509$XMLX509IssuerSerial = XMLX509IssuerSerial.class$("com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509IssuerSerial")) : class$com$sun$org$apache$xml$internal$security$keys$content$x509$XMLX509IssuerSerial).getName());
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$keys$content$x509$XMLX509IssuerSerial;

    public XMLX509IssuerSerial(Element element, String string2) throws XMLSecurityException {
        super(element, string2);
    }

    public XMLX509IssuerSerial(Document document, String string2, BigInteger bigInteger) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        this.addTextElement(string2, "X509IssuerName");
        XMLUtils.addReturnToElement(this._constructionElement);
        this.addTextElement(bigInteger.toString(), "X509SerialNumber");
    }

    public XMLX509IssuerSerial(Document document, String string2, String string3) {
        this(document, string2, new BigInteger(string3));
    }

    public XMLX509IssuerSerial(Document document, String string2, int n) {
        this(document, string2, new BigInteger(Integer.toString(n)));
    }

    public XMLX509IssuerSerial(Document document, X509Certificate x509Certificate) {
        this(document, RFC2253Parser.normalize(x509Certificate.getIssuerDN().getName()), x509Certificate.getSerialNumber());
    }

    public BigInteger getSerialNumber() {
        String string2 = this.getTextFromChildElement("X509SerialNumber", "http://www.w3.org/2000/09/xmldsig#");
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "In dem X509SerialNumber wurde gefunden: " + string2);
        }
        return new BigInteger(string2);
    }

    public int getSerialNumberInteger() {
        return this.getSerialNumber().intValue();
    }

    public String getIssuerName() {
        return RFC2253Parser.normalize(this.getTextFromChildElement("X509IssuerName", "http://www.w3.org/2000/09/xmldsig#"));
    }

    public boolean equals(Object object) {
        if (!object.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        XMLX509IssuerSerial xMLX509IssuerSerial = (XMLX509IssuerSerial)object;
        return xMLX509IssuerSerial.getSerialNumber().equals(this.getSerialNumber()) && xMLX509IssuerSerial.getIssuerName().equals(this.getIssuerName());
    }

    public String getBaseLocalName() {
        return "X509IssuerSerial";
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

