/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms;

import com.sun.org.apache.xml.internal.security.algorithms.Algorithm;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.internal.security.algorithms.implementations.IntegrityHmac;
import com.sun.org.apache.xml.internal.security.exceptions.AlgorithmAlreadyRegisteredException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureAlgorithm
extends Algorithm {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm == null ? (class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm = SignatureAlgorithm.class$("com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm")) : class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm).getName());
    static boolean _alreadyInitialized = false;
    static HashMap _algorithmHash = null;
    protected SignatureAlgorithmSpi _signatureAlgorithm = null;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm;

    public SignatureAlgorithm(Document document, String string2) throws XMLSecurityException {
        super(document, string2);
        try {
            Class clazz = SignatureAlgorithm.getImplementingClass(string2);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Create URI \"" + string2 + "\" class \"" + clazz + "\"");
            }
            this._signatureAlgorithm = (SignatureAlgorithmSpi)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string2, illegalAccessException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string2, instantiationException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, instantiationException);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string2, ((Throwable)nullPointerException).getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, nullPointerException);
        }
    }

    public SignatureAlgorithm(Document document, String string2, int n) throws XMLSecurityException {
        this(document, string2);
        this._signatureAlgorithm.engineSetHMACOutputLength(n);
        ((IntegrityHmac)this._signatureAlgorithm).engineAddContextToElement(this._constructionElement);
    }

    public SignatureAlgorithm(Element element, String string2) throws XMLSecurityException {
        super(element, string2);
        String string3 = this.getURI();
        try {
            Class clazz = SignatureAlgorithm.getImplementingClass(string3);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Create URI \"" + string3 + "\" class \"" + clazz + "\"");
            }
            this._signatureAlgorithm = (SignatureAlgorithmSpi)clazz.newInstance();
            this._signatureAlgorithm.engineGetContextFromElement(this._constructionElement);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string3, illegalAccessException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string3, instantiationException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, instantiationException);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string3, ((Throwable)nullPointerException).getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, nullPointerException);
        }
    }

    public byte[] sign() throws XMLSignatureException {
        return this._signatureAlgorithm.engineSign();
    }

    public String getJCEAlgorithmString() {
        return this._signatureAlgorithm.engineGetJCEAlgorithmString();
    }

    public String getJCEProviderName() {
        return this._signatureAlgorithm.engineGetJCEProviderName();
    }

    public void update(byte[] byArray) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(byArray);
    }

    public void update(byte by) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(byArray, n, n2);
    }

    public void initSign(Key key) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitSign(key);
    }

    public void initSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitSign(key, secureRandom);
    }

    public void initSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitSign(key, algorithmParameterSpec);
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this._signatureAlgorithm.engineSetParameter(algorithmParameterSpec);
    }

    public void initVerify(Key key) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitVerify(key);
    }

    public boolean verify(byte[] byArray) throws XMLSignatureException {
        return this._signatureAlgorithm.engineVerify(byArray);
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public static void providerInit() {
        if (log == null) {
            log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm == null ? (class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm = SignatureAlgorithm.class$("com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm")) : class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm).getName());
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Init() called");
        }
        if (!_alreadyInitialized) {
            _algorithmHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string2, String string3) throws AlgorithmAlreadyRegisteredException, XMLSignatureException {
        String string4;
        Class clazz;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Try to register " + string2 + " " + string3);
        }
        if ((clazz = SignatureAlgorithm.getImplementingClass(string2)) != null && (string4 = clazz.getName()) != null && string4.length() != 0) {
            Object[] objectArray = new Object[]{string2, string4};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        try {
            _algorithmHash.put(string2, Class.forName(string3));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string2, classNotFoundException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, classNotFoundException);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string2, ((Throwable)nullPointerException).getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, nullPointerException);
        }
    }

    private static Class getImplementingClass(String string2) {
        if (_algorithmHash == null) {
            return null;
        }
        return (Class)_algorithmHash.get(string2);
    }

    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getBaseLocalName() {
        return "SignatureMethod";
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

