/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.jbpm2630;

import org.jbpm.AbstractJbpmTestCase;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmConfigurationTestHelper;
import org.jbpm.JbpmContext;

/**
 * {@link JbpmConfiguration#popJbpmConfiguration} does not implement a pop
 * operation.
 * 
 * @see <a href="https://jira.jboss.org/jira/browse/JBPM-2630">JBPM-2630</a>
 * @author Alejandro Guizar
 */
public class JBPM2630Test extends AbstractJbpmTestCase {

  JbpmConfiguration testConfiguration;
  JbpmConfiguration noLogConfiguration;

  protected void setUp() throws Exception {
    super.setUp();
    testConfiguration = JbpmConfiguration.getInstance();
    noLogConfiguration = JbpmConfiguration.parseResource("org/jbpm/jbpm2630/jbpm.nolog.cfg.xml");
  }

  protected void tearDown() throws Exception {
    noLogConfiguration.close();
    testConfiguration.close();
    super.tearDown();
  }

  public void testBlockStructuredContextClose() {
    JbpmContext testContext1 = testConfiguration.createJbpmContext();
    try {
      JbpmContext noLogContext = noLogConfiguration.createJbpmContext();
      try {
        JbpmContext testContext2 = testConfiguration.createJbpmContext();
        try {
          assertSame(testConfiguration,
            JbpmConfigurationTestHelper.getCurrentJbpmConfiguration());
        }
        finally {
          testContext2.close();
        }
        assertSame(noLogConfiguration,
          JbpmConfigurationTestHelper.getCurrentJbpmConfiguration());
      }
      finally {
        noLogContext.close();
      }
      assertSame(testConfiguration, JbpmConfigurationTestHelper.getCurrentJbpmConfiguration());
    }
    finally {
      testContext1.close();
    }
  }

  public void testUnstructuredContextClose() {
    JbpmContext testContext = testConfiguration.createJbpmContext();
    assertSame(testConfiguration,
      JbpmConfigurationTestHelper.getCurrentJbpmConfiguration());

    JbpmContext noLogContext = noLogConfiguration.createJbpmContext();
    assertSame(noLogConfiguration,
      JbpmConfigurationTestHelper.getCurrentJbpmConfiguration());

    // this will emit a block-structured warning, but still succeed
    testContext.close();
    noLogContext.close();

    assertNull(JbpmConfigurationTestHelper.getCurrentJbpmConfiguration());
  }
}
