package org.jbpm.graph.node;

import org.dom4j.Element;
import org.jbpm.JbpmContext;
import org.jbpm.db.GraphSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jpdl.JpdlException;

public class DbSubProcessResolver implements SubProcessResolver {

  private static final long serialVersionUID = 1L;

  public ProcessDefinition findSubProcess(Element subProcessElement) {
    // if this parsing is done in the context of a process deployment,
    // there is a database connection to look up the subprocess.
    // when there is no jbpmSession, the definition will be left null...
    // the test case can set it as appropriate.
    JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
    if (jbpmContext != null) {
      GraphSession graphSession = jbpmContext.getGraphSession();

      // now, we must be able to find the sub-process
      String subProcessName = subProcessElement.attributeValue("name");
      if (subProcessName == null) {
        throw new JpdlException("subprocess name is not specified: "
          + subProcessElement.getPath());
      }

      // if only the name is specified,
      String subProcessVersion = subProcessElement.attributeValue("version");
      if (subProcessVersion == null) {
        // select the latest version of the subprocess definition
        return graphSession.findLatestProcessDefinition(subProcessName);
      }

      // if the name and the version are specified
      try {
        // select the exact version of the subprocess definition
        int version = Integer.parseInt(subProcessVersion);
        return graphSession.findProcessDefinition(subProcessName, version);
      }
      catch (NumberFormatException e) {
        throw new JpdlException("bad subprocess version: " + subProcessVersion);
      }
    }

    return null;
  }
}
