/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.configuration;

import java.lang.reflect.Field;

import org.w3c.dom.Element;

import org.jbpm.JbpmException;

public class FieldInfo extends PropertyInfo {

  private static final long serialVersionUID = 1L;

  public FieldInfo(Element fieldElement, ObjectFactoryParser configParser) {
    super(fieldElement, configParser);
  }

  public void injectProperty(Object object, ObjectFactoryImpl objectFactory) {
    Field field = findField(object.getClass());
    field.setAccessible(true);
    Object value = objectFactory.getObject(getPropertyValueInfo());
    try {
      field.set(object, value);
    }
    catch (IllegalAccessException e) {
      throw new JbpmException(getClass() + " has no access to " + field, e);
    }
  }

  private Field findField(Class clazz) {
    String fieldName = getPropertyName();

    for (Class currentClass = clazz; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
      try {
        return clazz.getDeclaredField(fieldName);
      }
      catch (NoSuchFieldException e) {
        clazz = clazz.getSuperclass();
      }
    }

    throw new JbpmException("missing field '" + "' in " + clazz);
  }
}
