#!/bin/sh
#
# A script that uses Maven to build the project and
# execute its test suite against a given target container 
#
# $Id: command.sh 6303 2010-05-06 18:16:25Z alex.guizar@jboss.com $

WORKSPACE=$PWD
JBPMDIR=$WORKSPACE/jbpm

#
# Extract JBoss distro
#
case "$CONTAINER" in
  jboss405*)
    JBOSS_BUILD=jboss-4.0.5.GA
    ;;
  jboss423*)
    JBOSS_BUILD=jboss-4.2.3.GA
    ;;
  jboss501*)
    JBOSS_BUILD=jboss-5.0.1.GA
    ;;
  jboss510*)
    JBOSS_BUILD=jboss-5.1.0.GA
    ;;
esac
JBOSS_HOME=$WORKSPACE/$JBOSS_BUILD

rm -rf $JBOSS_BUILD
unzip -q $HUDSON_BASE/jboss/$JBOSS_BUILD.zip

#
# Determine Java platform version
#
java -version 2> version.tmp
JAVA_VERSION=`grep "java version" version.tmp | awk '{ print substr($3, 2, length($3)-2); }'`
rm version.tmp
echo java version $JAVA_VERSION

case $JAVA_VERSION in
  1.4*)
    JAVA_BT_HOME=$JAVA_15_HOME
    JAVA_RT_HOME=$JAVA_14_HOME
    JAVA=$JAVA_BT_HOME/bin/java
    ;;
  *)
    JAVA_BT_HOME=$JAVA_HOME
    JAVA_RT_HOME=$JAVA_HOME
    JAVA=java
    ;;
esac

#
# Set up Maven
#
MVN_OPTS="-Ddatabase=$DATABASE -Dcontainer=$CONTAINER -Djboss.home=$JBOSS_HOME -Djboss.bind.address=$JBOSS_BINDADDR"
cp "$JBPMDIR/hudson/profiles.redhat.qa.xml" "$JBPMDIR/profiles.xml"

#
# Build distro
#
cd $JBPMDIR
export JAVA_HOME=$JAVA_BT_HOME
MVN_CMD="mvn -U $MVN_OPTS -Pdistro,soa clean install"
echo $MVN_CMD; $MVN_CMD; MVN_STATUS=$?
if [ $MVN_STATUS -ne 0 ]; then
  echo maven exit status $MVN_STATUS
  exit 1
fi

#
# Install distro
#
JBPM_VERSION=`echo project version \$\{project.version\} | mvn help:evaluate | grep 'project version' | awk '{ print $3 }'`
echo jbpm version $JBPM_VERSION
AUTO_INSTALL=modules/distribution/target/resources/auto-install-template.xml; cat $AUTO_INSTALL;
JAVA_CMD="$JAVA -jar modules/distribution/target/jbpm-installer-$JBPM_VERSION.jar $AUTO_INSTALL"
echo $JAVA_CMD; $JAVA_CMD 

#
# Install non-redistributable JDBC drivers
#
MVN_CMD="mvn -o -N $MVN_OPTS -DoutputFile=resolve.tmp dependency:resolve"
echo $MVN_CMD; $MVN_CMD
cat resolve.tmp

# Install DB2 driver
if [ "$DATABASE" = "db2" ]; then
  DB2JCC_VERSION=`grep com.ibm:db2jcc:jar resolve.tmp | awk --field-separator : '{ print $4 }'`
  DB2JCC_JAR=~/.m2/repository/com/ibm/db2jcc/$DB2JCC_VERSION/db2jcc-$DB2JCC_VERSION.jar
  if [ -f $DB2JCC_JAR ]; then
    CP_CMD="cp $DB2JCC_JAR $JBOSS_HOME/server/$JBOSS_SERVER/lib"
    echo $CP_CMD; $CP_CMD
  else
    echo "WARNING: DB2 driver not found: $DB2JCC_JAR"
  fi
  DB2JCC_LICENSE=~/.m2/repository/com/ibm/db2jcc_license_cu/$DB2JCC_VERSION/db2jcc_license_cu-$DB2JCC_VERSION.jar
  if [ -f $DB2JCC_LICENSE ]; then
    CP_CMD="cp $DB2JCC_LICENSE $JBOSS_HOME/server/$JBOSS_SERVER/lib"
    echo $CP_CMD; $CP_CMD
  else
    echo "WARNING: DB2 license not found: $DB2JCC_LICENSE"
  fi
fi

# Install MSSQL driver
if [ "$DATABASE" = "mssql" ]; then
  MSJDBC_VERSION=`grep com.microsoft.sqlserver:msjdbc resolve.tmp | awk --field-separator : '{ print $4 }'`
  MSJDBC_JAR=~/.m2/repository/com/microsoft/sqlserver/msjdbc/$MSJDBC_VERSION/msjdbc-$MSJDBC_VERSION.jar
  if [ -f $MSJDBC_JAR ]; then
    CP_CMD="cp $MSJDBC_JAR $JBOSS_HOME/server/$JBOSS_SERVER/lib"
    echo $CP_CMD; $CP_CMD
  else
    echo "WARNING: MSSQL driver not found: $MSSQL_JAR"
  fi
fi

# Install Oracle driver
if [ "$DATABASE" = "oracle" ]; then
  OJDBC_VERSION=`grep com.oracle:ojdbc14 resolve.tmp | awk --field-separator : '{ print $4 }'`
  OJDBC_JAR=~/.m2/repository/com/oracle/ojdbc14/$OJDBC_VERSION/ojdbc14-$OJDBC_VERSION.jar
  if [ -f $OJDBC_JAR ]; then
    CP_CMD="cp $OJDBC_JAR $JBOSS_HOME/server/$JBOSS_SERVER/lib"
    echo $CP_CMD; $CP_CMD
  else
    echo "WARNING: Oracle driver not found: $OJDBC_JAR"
  fi
fi

# Install Sybase driver
if [ "$DATABASE" = "sybase" ]; then
  JCONNECT_VERSION=`grep com.sybase:jconnect resolve.tmp | awk --field-separator : '{ print $4 }'`
  JCONNECT_JAR=~/.m2/repository/com/sybase/jconnect/$JCONNECT_VERSION/jconnect-$JCONNECT_VERSION.jar
  if [ -f $JCONNECT_JAR ]; then
    CP_CMD="cp $JCONNECT_JAR $JBOSS_HOME/server/$JBOSS_SERVER/lib"
    echo $CP_CMD; $CP_CMD
  else
    echo "WARNING: Sybase driver not found: $JCONNECT_JAR"
  fi
fi

# Remove resolution output file
rm resolve.tmp

#
# Start JBoss AS
#
export JAVA_HOME=$JAVA_RT_HOME
$JBPMDIR/hudson/jboss/bin/jboss.sh $JBOSS_HOME start $JBOSS_BINDADDR

# Was it successfully started?
$JBPMDIR/hudson/jboss/bin/http-spider.sh $JBOSS_BINDADDR:8080 $WORKSPACE
if [ -e $WORKSPACE/spider.failed ]; then
  tail -n 100 $JBOSS_HOME/server/$JBOSS_SERVER/log/server.log
  $JBPMDIR/hudson/jboss/bin/jboss.sh $JBOSS_HOME stop $JBOSS_BINDADDR
  exit 1
fi

#
# Log dependency tree
#
MVN_CMD="mvn -o $MVN_OPTS dependency:tree"
echo $MVN_CMD; $MVN_CMD | tee $WORKSPACE/dependency-tree.txt

#
# Give tests a max memory amount of at least 256 MB
#
TOTAL_MEM=`free -mo | grep Mem | awk '{ print $2 }'`
echo "Total memory: $TOTAL_MEM"
MAX_MEM=`expr $TOTAL_MEM / 4`
[ $MAX_MEM -lt 256 ] && MAX_MEM=256
MVN_OPTS="$MVN_OPTS -Dsurefire.jvm.args=-Xmx$MAX_MEM"m

#
# Execute tests
#
MVN_CMD="mvn -o -fae $MVN_OPTS test"
echo $MVN_CMD; $MVN_CMD 2>&1 | tee $WORKSPACE/tests.log
cat $WORKSPACE/tests.log | egrep FIXME\|FAILED | sort -u | tee $WORKSPACE/fixme.txt
cat $WORKSPACE/fixme.txt | egrep "\[\S*]" > $WORKSPACE/errata-$CONTAINER.txt

#
# Stop JBoss AS
#
$JBPMDIR/hudson/jboss/bin/jboss.sh $JBOSS_HOME stop
cp $JBOSS_HOME/server/$JBOSS_SERVER/log/boot.log $WORKSPACE/jboss-boot.log
cp $JBOSS_HOME/server/$JBOSS_SERVER/log/server.log $WORKSPACE/jboss-server.log
