/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.quickstart.test;

import junit.framework.Test;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.io.InputStreamReader;

import org.jboss.internal.soa.esb.util.StreamUtils;

/**
 * CI test for the http-gateway quickstart.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */

public class HttpGatewayTest extends AbstractQuickstartTestCase {

	public HttpGatewayTest(String name) {
		super(name);
	}

	public void testMessage() throws Exception {
	    clearMessages() ;
	    sendMessage() ;
	    sendPorts01Message() ;
	    sendPorts02Message() ;
	}

	public void sendMessage() throws Exception {
        URL request = new URL("http://localhost:8080/Quickstart_http_gateway/http/index/XXXX/yyy?param1=value1");

        URLConnection connection = request.openConnection();
        connection.connect();
        InputStreamReader reader = new InputStreamReader(connection.getInputStream());
        try {
            String response = StreamUtils.readReader(reader);

            assertTrue(response.indexOf("Service: Index:List") != -1);
            assertTrue(response.indexOf("<pathInfo>/XXXX/yyy</pathInfo>") != -1);
        } finally {
            reader.close();
        }
    }

	public void sendPorts01Message() throws Exception {
        URL request = new URL("http://localhost:8080/Quickstart_http_gateway/http/ports01");

        HttpURLConnection connection = (HttpURLConnection)request.openConnection();
        connection.connect();
        assertEquals(HttpURLConnection.HTTP_NOT_FOUND, connection.getResponseCode());
    }

	public void sendPorts02Message() throws Exception {
        URL request = new URL("http://localhost:8080/Quickstart_http_gateway/http/ports02");

        HttpURLConnection connection = (HttpURLConnection)request.openConnection();
        connection.connect();
        assertEquals(HttpURLConnection.HTTP_OK, connection.getResponseCode());
    }

	public static Test suite() throws Exception {
		return getDeploySetup(HttpGatewayTest.class,
				"QuickstartMessageStoreServer.sar, Quickstart_http_gateway.esb");
	}
}