/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.quickstart.test;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstart.exceptions.test.SendJMSMessage;

/**
 * CI test for the exceptionsfaults quickstart.
 *
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @author <a href="mailto:ldimaggi@redhat.com">Len Dimaggio</a>
 */
public class ExceptionsFaultsTest extends AbstractQuickstartTestCase {
	private static final String JMS_MESSAGE = "HelloWorldTest message";

	public ExceptionsFaultsTest(String name) {
		super(name);
	}

	public void testMessage() throws Exception {
	    clearMessages() ;
            sendMessage();
            checkMessages(30000, JMS_MESSAGE, JMS_MESSAGE, "CHECK") ;
	}

	public void sendMessage() throws Exception {
		SendJMSMessage sm = new SendJMSMessage();
		sm.setupConnection("queue/quickstart_exceptions_faults_GW");
		sm.sendAMessage("ExceptionCaughtService", "Via Gateway");
		sm.stop();
	}

	public static Test suite() throws Exception {
		return getDeploySetup(ExceptionsFaultsTest.class, "QuickstartMessageStoreServer.sar, Quickstart_exceptions_faults.esb");
	}
}
