/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.server.jbpmReply;

import javax.management.ObjectName;

import junit.framework.Test;

import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.LogicalEPR;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.server.RedeliveryMBean;
import org.jboss.test.JBossTestCase;
import java.util.Arrays;
import java.util.List;

/**
 * Test local variables for jBPM processes.
 * 
 * @author <a href='mailto:kevin.conner@jboss.com'>Kevin Conner</a>
 */
public class JbpmReplyUnitTest extends JBossTestCase
{
    /**
     * The name of the deployment archive.
     */
    private static final String ESB_ARCHIVE = "jbpm-reply-test.esb" ;
    
    /**
     * Construct the test case with the specified name.
     * @param name The name of the test case.
     */
    public JbpmReplyUnitTest(final String name)
    {
        super(name) ;
    }
    
    /**
     * Test for replies.
     * @throws Exception For any failures.
     */
    public void testReplies()
        throws Exception
    {
        getServer().invoke(new ObjectName(JbpmServerMBean.OBJECT_NAME), "deployProcess", null, null) ;
        
        final Message message = MessageFactory.getInstance().getMessage() ;
        final Call call = message.getHeader().getCall() ;
        final EPR replyToEPR = new LogicalEPR("TestJBPMReplyESB", "Reply") ;
        replyToEPR.getAddr().addExtension(ReplyAction.REPLY_TYPE, "reply") ;
        call.setReplyTo(replyToEPR) ;
        
        final EPR faultToEPR = new LogicalEPR("TestJBPMReplyESB", "Reply") ;
        faultToEPR.getAddr().addExtension(ReplyAction.REPLY_TYPE, "fault") ;
        call.setFaultTo(faultToEPR) ;
        
        final ServiceInvoker si = new ServiceInvoker("TestJBPMReplyESB", "Create") ;
        si.deliverAsync(message) ;
        
        final int numMessages = 4 ;
        final String[] messages = (String[])getServer().invoke(new ObjectName(RedeliveryMBean.objectName), "waitForMessages",
                new Integer[] {Integer.valueOf(numMessages)}, new String[] { Integer.TYPE.getName() });
		List messageList = Arrays.asList(messages);
        assertNotNull("log messages", messages) ;
        assertEquals("Message count", numMessages, messages.length) ;
        for(int count = 0 ; count < numMessages ; count++)
        {
            assertNotNull("Message: " + count, messages[count]) ;
        }
        assertTrue("Reply notification", messageList.contains("EsbNotifier:reply"));
        assertTrue("Reply action", messageList.contains("EsbActionHandler:reply"));
        assertTrue("Fault notification", messageList.contains("EsbNotifier:fault"));
        assertTrue("Fault action", messageList.contains("EsbActionHandler:fault"));
    }
    
    /**
     * Create the test suite.
     * @return The suite representing this test case.
     */
    public static Test suite()
        throws Exception
    {
        return getDeploySetup(JbpmReplyUnitTest.class, ESB_ARCHIVE);
    }
}
