/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.jms;

import junit.framework.Test;
import org.jboss.soa.esb.util.TestDeploymentArchive;
import org.jboss.soa.esb.testutils.JMSUtil;
import org.jboss.test.JBossTestCase;

import java.io.File;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class JmsGatewayListenerUnitTest extends JBossTestCase {

    TestDeploymentArchive deployment;

    public JmsGatewayListenerUnitTest(String name) {
        super(name);
    }

    public void test() throws Exception {
        File file1 = new File("build/" + TargetServiceAction.FILE_PREFIX + "Service1-Received");
        File file2 = new File("build/" + TargetServiceAction.FILE_PREFIX + "Service2-Received");

        file1.delete();
        file2.delete();
        JMSUtil.sendMessageToTopic("Howya", "topic/JmsGatewayListenerUnitTest_topic", null);

        long start = System.currentTimeMillis();
        while(System.currentTimeMillis() < (start + 20000)) {
            if(file1.exists() && file2.exists()) {
                // Test passed...
                return;
            }
            Thread.sleep(500);
        }

        fail("Test failed to deliver files to build dir: " + file1.getAbsolutePath() + ", " + file2.getAbsolutePath());
    }

    public static Test suite() throws Exception {
        createEsbDeployment();

        return getDeploySetup(JmsGatewayListenerUnitTest.class, "JmsGatewayListenerUnitTest.esb");
    }

    private static void createEsbDeployment() {
        TestDeploymentArchive deployment = new TestDeploymentArchive("JmsGatewayListenerUnitTest.esb");

        deployment.addEntry("META-INF/jboss-esb.xml", JmsGatewayListenerUnitTest.class.getResourceAsStream("jboss-esb.xml"));
        deployment.addEntry("META-INF/deployment.xml", JmsGatewayListenerUnitTest.class.getResourceAsStream("deployment.xml"));
        deployment.addEntry("jms-service.xml", JmsGatewayListenerUnitTest.class.getResourceAsStream("JmsGatewayListenerUnitTest-service.xml"));
        deployment.addEntry(MessageAugmentor.class);
        deployment.addEntry(TargetServiceAction.class);

        deployment.create();
    }
}
