/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.registry.rmi;

import java.util.Properties;

import javax.naming.InitialContext;

/**
 * @author Tom Cunningham (tcunning@redhat.com)
 */
public class JNDIRegistration
{	
	public static final String DEFAULT_JAVA_NAMING_FACTORY_INITIAL = "org.jnp.interfaces.NamingContextFactory";
	public static final String DEFAULT_JAVA_NAMING_PROVIDER_URL = "jnp://localhost:1099";
	public static final String DEFAULT_JAVA_NAMING_FACTORY_URL_PKGS = "org.jboss.naming";

	public static final String PROPNAME_JAVA_NAMING_FACTORY_INITIAL = "java.naming.factory.initial";
	public static final String PROPNAME_JAVA_NAMING_PROVIDER_URL = "java.naming.provider.url";
	public static final String PROPNAME_JAVA_NAMING_FACTORY_URL_PKGS = "java.naming.factory.url.pkgs";

	public static Inquiry inquiryReg = null;
	public static Publish publishReg = null;

	public static String INQUIRY_SERVICE="/InquiryService";
	public static String PUBLISH_SERVICE="/PublishService";
	
	public static void register(RegistrationService regService)
	{
		try {
            String factoryInitial = System.getProperty(PROPNAME_JAVA_NAMING_FACTORY_INITIAL);
            String providerURL    = System.getProperty(PROPNAME_JAVA_NAMING_PROVIDER_URL);
            String factoryURLPkgs = System.getProperty(PROPNAME_JAVA_NAMING_FACTORY_URL_PKGS);

            if (factoryInitial == null) { 
            	factoryInitial = DEFAULT_JAVA_NAMING_FACTORY_INITIAL;
            } 
			if (providerURL == null) { 
                providerURL = DEFAULT_JAVA_NAMING_PROVIDER_URL;
            } 
            
			if (factoryURLPkgs == null) {
                factoryURLPkgs = DEFAULT_JAVA_NAMING_FACTORY_URL_PKGS;
            } 
			
			Properties env = new Properties();
			env.setProperty(PROPNAME_JAVA_NAMING_FACTORY_INITIAL, factoryInitial);
			env.setProperty(PROPNAME_JAVA_NAMING_PROVIDER_URL, providerURL);
			env.setProperty(PROPNAME_JAVA_NAMING_FACTORY_URL_PKGS, factoryURLPkgs); 
			
			InitialContext context = new InitialContext(env);
			Inquiry inquiry = new InquiryService();
			
			((InquiryService)inquiry).setRegistrationService(regService);
			inquiryReg = inquiry;
			context.rebind(INQUIRY_SERVICE, inquiry);
			Publish publish = new PublishService();
			((PublishService)publish).setRegistrationService(regService);
			
			publishReg = publish;
			context.rebind(PUBLISH_SERVICE, publish);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
