/*
 * RHQ Management Platform
 * Copyright (C) 2005-2008 Red Hat, Inc.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.jbosson.plugins.jbossesb;

import java.util.Set;

import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jmx.MBeanResourceComponent;

import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;


/**
 * The ListenerComponent finds ESB configuration data stored in jboss-esb.xml.
 * 
 * @author Tom Cunningham
 */
public class ListenerComponent extends MBeanResourceComponent<MBeanResourceComponent> {
    private ResourceContext<MBeanResourceComponent> context;

    private static final String MEP = "mep";
    private static final String LIFECYCLE_STATE = "LifeCycleState";
    private static final String MAX_THREADS = "maxThreads";
    private static final String START_DATE = "StartDate";
    private static final String SERVICE_CATEGORY = "service-category";
    private static final String SERVICE_NAME = "service-name";
    private static final String SERVICE_DESCRIPTION = "service-description";
    
    @Override
    public void start(ResourceContext<MBeanResourceComponent> context) {
        super.start(context);
        this.context = context;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
    	Configuration pluginConfig = this.context.getPluginConfiguration();
    	pluginConfig.put(new PropertySimple("type", "service"));
        for (MeasurementScheduleRequest request : requests) {
        	String metricName = request.getName();
        	if (metricName.equals(MEP)) {
        		EmsAttribute attribute = getEmsBean().getAttribute(MEP);
        		String processed = new String();
        		if (attribute != null) {
        			processed = (String) attribute.refresh();
        		}
        		report.addData(new MeasurementDataTrait(request, processed));
        	} else if (metricName.equals(LIFECYCLE_STATE)) {
        		EmsAttribute attribute = getEmsBean().getAttribute(LIFECYCLE_STATE);
        		String processed = new String();
        		if (attribute != null) {
        			processed = (String) attribute.refresh();
        		}
        		report.addData(new MeasurementDataTrait(request, processed));
        	} else if (metricName.equals(MAX_THREADS)) {
        		EmsAttribute attribute = getEmsBean().getAttribute(MAX_THREADS);
        		String processed = new String();
        		if (attribute != null) {
        			processed = (String) attribute.refresh();
        		}
        		report.addData(new MeasurementDataTrait(request, processed));        		
        	} else if (metricName.equals(START_DATE)) {
        		EmsAttribute attribute = getEmsBean().getAttribute(START_DATE);
        		String processed = new String();
        		if (attribute != null) {
        			processed = (String) attribute.refresh();
        		}
        		report.addData(new MeasurementDataTrait(request, processed));        		
        	} else if (metricName.equals(SERVICE_CATEGORY)) {
        		EmsAttribute attribute = getEmsBean().getAttribute(SERVICE_CATEGORY);
        		String processed = new String();
        		if (attribute != null) {
        			processed = (String) attribute.refresh();
        		}
        		report.addData(new MeasurementDataTrait(request, processed));        		
        	} else if (metricName.equals(SERVICE_NAME)) {
        		EmsAttribute attribute = getEmsBean().getAttribute(SERVICE_NAME);
        		String processed = new String();
        		if (attribute != null) {
        			processed = (String) attribute.refresh();
        		}
        		report.addData(new MeasurementDataTrait(request, processed));        		
        	} else if (metricName.equals(SERVICE_DESCRIPTION)) {
        		EmsAttribute attribute = getEmsBean().getAttribute(SERVICE_DESCRIPTION);
        		String processed = new String();
        		if (attribute != null) {
        			processed = (String) attribute.refresh();
        		}
        		report.addData(new MeasurementDataTrait(request, processed));        		
        	}
        }
    }
}
