package org.jbosson.plugins.jbossesb;
import java.util.Iterator;
import java.util.Set;

import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;

/**
 * This DiscoveryComponent extends the MBeanResouceDiscoveryComponent, but also
 * adds in the version number from the application server. 
 *
 * @author Tom Cunningham
 */
public class ESBDiscoveryComponent extends MBeanResourceDiscoveryComponent<JMXComponent> {    
	private static final String NAME = "name";
	private static final String RESOURCE_KEY  = "key";
	private static final String SERVICE_DESCRIPTION = "service description";

	@Override
	public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent> context) {
        Set<DiscoveredResourceDetails> jmxResources = super.discoverResources(context);

        String versionNumber;
        String description = null;
		EmsBean bean = context.getParentResourceComponent().getEmsConnection().getBean(SOADiscoveryComponent.SYSTEM_BEAN);
		String resourceKey = null;
		
		for (Iterator i = jmxResources.iterator(); i.hasNext();) {
        	DiscoveredResourceDetails drd = (DiscoveredResourceDetails) i.next();
        	resourceKey = drd.getResourceKey();
		}
		
		try {
		    EmsAttribute versionAttribute = bean.getAttribute(SOADiscoveryComponent.VERSION_NUMBER);		
		    versionNumber = (String) versionAttribute.refresh();
        } catch (Exception e) {
        	versionNumber = "";
        }

        try {
        	EmsBean discoverBean = context.getParentResourceComponent().getEmsConnection().getBean(resourceKey);
        	String name = discoverBean.getBeanName().getKeyProperty(NAME);
        	Set<EmsAttribute> attributeSet = discoverBean.getAttributes();
        	for (Iterator i = attributeSet.iterator(); i.hasNext();) {
        		EmsAttribute attr = (EmsAttribute) i.next();

        		if (attr.getName().endsWith(SERVICE_DESCRIPTION)) {
        			description = (String) attr.getValue();
        			if (description != null)
        			{
        				description = description.trim();
        			}
        		}
        	}
        } catch (Exception e) {
        }
        if ((description == null) || (description.length() == 0)) {
            description = "Service Entity";
        }
        
        for (DiscoveredResourceDetails jmxResource : jmxResources) {
        	jmxResource.setResourceVersion(versionNumber);
        	jmxResource.setResourceDescription(description);
        }

        return jmxResources;
    }
}