package org.jbosson.plugins.jbossesb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationContext;
import org.rhq.core.pluginapi.util.ResponseTimeLogParser;
import org.rhq.plugins.jmx.MBeanResourceComponent;

public abstract class AbstractESBComponent extends MBeanResourceComponent implements CreateChildResourceFacet, ContentFacet {
   protected static final String RESOURCE_TYPE_ESB = "Deployment";

   protected String configSet;
   protected ResponseTimeLogParser logParser;
   protected File configPath;

   protected ContentContext contentContext;
   protected OperationContext operationContext;
   public static final String CONTEXT_ROOT_CONFIG_PROP = "contextRoot";
   // The following constants reference the exact name of the package types as defined in the plugin descriptor
   protected static final String PACKAGE_TYPE_PATCH = "cumulativePatch";
   protected static final String PACKAGE_TYPE_LIBRARY = "library";

   public static final String CONFIGURATION_PATH_CONFIG_PROP = "configurationPath";
   public static final String SCRIPT_PREFIX_CONFIG_PROP = "scriptPrefix";
   public static final String CONFIGURATION_SET_CONFIG_PROP = "configurationSet";

   public static final String JBOSS_HOME_DIR_CONFIG_PROP = "jbossHomeDir";

   
   @Override
   public void start(ResourceContext context) {
	   super.start(context);
	   Configuration pluginConfig = context.getPluginConfiguration();

	   this.configPath = getConfigurationPath();
	   if (!this.configPath.exists()) {
		   throw new InvalidPluginConfigurationException("Configuration path '" + configPath + "' does not exist.");
	   }
	   this.configSet = pluginConfig.getSimpleValue(CONFIGURATION_SET_CONFIG_PROP, this.configPath.getName());
   }
   
   abstract File getConfigurationPath();
     
   @Override
   public AvailabilityType getAvailability() {
	   AvailabilityType av = super.getAvailability();
	   return av;
   }
      
   //abstract void esbCreate(CreateResourceReport report, String resourceTypeName);

	/*
   public CreateResourceReport createResource(CreateResourceReport report) {
        String resourceTypeName = report.getResourceType().getName();

        if (resourceTypeName.equals(RESOURCE_TYPE_ESB)) {
            esbCreate(report, resourceTypeName);
        } else {
            throw new UnsupportedOperationException("Unknown Resource type: " + resourceTypeName);
        }

        // JBNADM-1984 - The contract with this method is that the newly created managed resource should be discoverable.
        //               Wait here so JBoss can recognize that the new managed resource has been created.
        try {
            Thread.sleep(5000L);
        } catch (InterruptedException e) {
            log.info("Sleep after datasource create interrupted", e);
        }

        return report;
    }
   */
   
	public DeployPackagesResponse deployPackages(
			Set<ResourcePackageDetails> packages,
			ContentServices contentServices) {
        ContentResponseResult overallResult = ContentResponseResult.SUCCESS;
        List<DeployIndividualPackageResponse> individualResponses = new ArrayList<DeployIndividualPackageResponse>(
            packages.size());

        for (ResourcePackageDetails pkg : packages) {
            log.info("Attempting to deploy package: " + pkg);

            String packageTypeName = pkg.getPackageTypeName();
            if (packageTypeName.equals(PACKAGE_TYPE_LIBRARY)) {
                throw new UnsupportedOperationException("Deployment of new libraries is not supported by the plugin.");
            }
        }

        DeployPackagesResponse response = new DeployPackagesResponse(overallResult);
        response.getPackageResponses().addAll(individualResponses);

        return response;
	}

	public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
		return null;
	}

	public List<DeployPackageStep> generateInstallationSteps(
			ResourcePackageDetails packageDetails) {
		return null;
	}

	public RemovePackagesResponse removePackages(
			Set<ResourcePackageDetails> packages) {
        throw new UnsupportedOperationException();
	}

	public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        throw new UnsupportedOperationException();
	}
}

