package org.jbosson.plugins.jbossesb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.util.FileContentDelegate;

public class ESBComponent extends AbstractESBComponent {
   public File getConfigurationPath() {
	   JBossASServerComponent jass = (JBossASServerComponent) resourceContext.getParentResourceComponent();
	   return jass.getConfigurationPath();
   }

   protected void esbCreate(CreateResourceReport report, String resourceTypeName) {
        ResourcePackageDetails details = report.getPackageDetails();
        PackageDetailsKey key = details.getKey();
        String archiveName = key.getName();

        try {
            // First check to see if the file name has the correct extension. Reject if the user attempts to
            // deploy a WAR file with a bad extension.
            String expectedExtension;
            if (resourceTypeName.equals(RESOURCE_TYPE_ESB)) {
                expectedExtension = "esb";
            } else {
                expectedExtension = "";
            }
	        
            int lastPeriod = archiveName.lastIndexOf(".");
	        String extension = archiveName.substring(lastPeriod + 1);
	        if (lastPeriod == -1 || !expectedExtension.equals(extension)) {
	        	report.setStatus(CreateResourceStatus.FAILURE);
	            report.setErrorMessage("Incorrect extension specified on filename [" + archiveName + "]. Expected ["
	            	+ expectedExtension + "]");
	            return;
	        }

            Configuration deployTimeConfiguration = details.getDeploymentTimeConfiguration();
            String deployDirectory = deployTimeConfiguration.getSimple("deployDirectory").getStringValue();

            // Verify the user did not enter a path that represents a security issue:
            // - No absolute directories; must be relative to the configuration path
            // - Cannot contain parent directory references
            File testPath = new File(deployDirectory);

            if (testPath.isAbsolute()) {
            	throw new RuntimeException("Path to deploy (deployDirectory) must be a relative path. Path specified: "
	                    + deployDirectory);
            }
            
            if (deployDirectory.contains("..")) {
	        	throw new RuntimeException(
	            	"Path to deploy (deployDirectory) may not reference the parent directory. Path specified: "
	                	+ deployDirectory);
	        }

	        // Perform the deployment
            FileContentDelegate deployer = new FileContentDelegate(new File(getConfigurationPath(), deployDirectory),
                    "", details.getPackageTypeName());

            PropertySimple zipProperty = deployTimeConfiguration.getSimple("deployZipped");

	        if (zipProperty != null && zipProperty.getBooleanValue() != null) {
	        	boolean zip = zipProperty.getBooleanValue();

	            File tempDir = resourceContext.getTemporaryDirectory();
	            File tempFile = new File(tempDir.getAbsolutePath(), "esb.bin");
	            OutputStream osForTempDir = new BufferedOutputStream(new FileOutputStream(tempFile));

	            contentContext = resourceContext.getContentContext();
	            ContentServices contentServices = contentContext.getContentServices();
	            contentServices
	                    .downloadPackageBitsForChildResource(contentContext, resourceTypeName, key, osForTempDir);

	            osForTempDir.close();

	            InputStream isForTempDir = new BufferedInputStream(new FileInputStream(tempFile));
	            deployer.createContent(details, isForTempDir, !zip, false);

                // Resource key should match the following:      
                // ESB: jboss.esb:deployment=jbossesb.esb

                String resourceKey;
                resourceKey = "jboss.esb:deployment=" + archiveName;

                report.setResourceName(archiveName);
                report.setResourceKey(resourceKey);
                report.setStatus(CreateResourceStatus.SUCCESS);
            } else {
                report.setStatus(CreateResourceStatus.FAILURE);
                report.setErrorMessage("Zipped property is required");
            }
        } catch (Throwable t) {
            log.error("Error deploying application for report: " + report, t);
            report.setException(t);
            report.setStatus(CreateResourceStatus.FAILURE);
        }
    }
   
   public CreateResourceReport createResource(CreateResourceReport report) {
       String resourceTypeName = report.getResourceType().getName();

       if (resourceTypeName.equals(RESOURCE_TYPE_ESB)) {
           esbCreate(report, resourceTypeName);
       } else {
           throw new UnsupportedOperationException("Unknown Resource type: " + resourceTypeName);
       }

       // JBNADM-1984 - The contract with this method is that the newly created managed resource should be discoverable.
       //               Wait here so JBoss can recognize that the new managed resource has been created.
       try {
           Thread.sleep(5000L);
       } catch (InterruptedException e) {
           log.info("Sleep after datasource create interrupted", e);
       }

       return report;
   }
}
